/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Last Modification:
    @version $Id: S3M_CP_Public.h 63627 2016-08-30 14:24:44Z Sven $

   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    1           03.03.2008  sb      created
    2           28.04.2009  uj      SIII_MA_CP_CMD_GET_COMM_COUNTERS_REQ and
                                    SIII_MA_CP_CMD_GET_BUS_INFO_REQ stuff
                                    removed (was never used)
    3           01.03.2010  uj      removed some packets (was never implemented und not necessary for the future)
                                    -SIII_MA_CP_CMD_SET_TO_FAST_FORWARD_TO_PRED_REQ
                                    -SIII_MA_CP_CMD_SET_TO_FAST_FORWARD_TO_SUCC_REQ
                                    -SIII_MA_CP_CMD_ENABLE_AUTOMATIC_FAST_FORWARD_SWITCH_REQ
                                    -SIII_MA_CP_CMD_DISABLE_AUTOMATIC_FAST_FORWARD_SWITCH_REQ
                                    -SIII_MA_CP_CMD_READ_ERROR_HISTORY_ENTRY_REQ
                                    -SIII_MA_CP_CMD_GET_SLAVE_STATUS_REQ
    4           18.03.2011  sb      removed stack internal commands from public header
                                    -SIII_MA_CP_CMD_SET_BUS_ON_REQ
                                    -SIII_MA_CP_CMD_SET_BUS_OFF_REQ
                                    -SIII_MA_CP_CMD_NRT_DUE_BUS_ERROR_REQ

*******************************************************************************/

#ifndef S3M_CP_PUBLIC_H_INCLUDED
#define S3M_CP_PUBLIC_H_INCLUDED

/***************************************************************************************/
/* SIII MA CP public, constants */

#define SIII_MA_CP_PROCESS_QUEUE_NAME       "QUE_S3M_CP"


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(SIII_MA_CP_PUBLIC)
#endif

#define S3_IDN_TYPE_S     0
#define S3_IDN_TYPE_P     0x8000

#define S3_IDN(type, set, number,  si, se)        \
            (                                     \
              S3_IDN_TYPE_##type |                \
              ((((uint8_t)(set)) & 0x7) << 12) |  \
              (((uint16_t)(number)) & 4095) |     \
              ((((uint8_t)(si)) & 0xFF) << 24) |  \
              ((((uint8_t)(se)) & 0xFF) << 16)    \
            )

//  SIII_MA_CP_PACKET_COMMAND_START             = 0x00004800,

/*
 * Packet Ranges:
 * 0x4800-0x480F - Communication Phase Control
 * 0x4810-0x481F - Topology Detect Functions
 * 0x4820-0x482F/0x4870-0x487F - Configuration Packet Interface
 * 0x4830-0x483F - Phase Indications
 * 0x4840-0x484F - Diagnostics (0x4848 and 0x484A used for BusOn/Off only usable by AP task)
 * 0x4850-0x485F - Special Commands
 * 0x4860-0x4869 - Diagnostic Loggging
 * 0x4890-0x4897 - Bus Scan
 * 0x4898-0x489F - AP task communication
 * 0x4880-0x488F - Special Controls
 * 0x48A0-0x48AF - Error History
 * 0x48C0-0x48C3 - Indications for UNCONFIGURED_SLAVE_DETECTED and DUPLICATE_SERCOS_ADDRESS
 * 0x486A-0x486F - Indications
 * 0x48C4-0x48DF - reserved for debug information packets
 *
 * 0x8900-0x89FF - new command set for additional commands
 */

/**********************************************************************************************************************/

#define SIII_MA_CP_CMD_GET_SUPPORTED_APIS_REQ               0x00008902
#define SIII_MA_CP_CMD_GET_SUPPORTED_APIS_CNF               0x00008903

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_SUPPORTED_APIS_REQ/SIII_MA_CP_CMD_GET_SUPPORTED_APIS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SUPPORTED_APIS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_SUPPORTED_APIS_REQ_T;


/* confirmation packet */
#define SIII_MA_CP_GET_SUPPORTED_APIS_MAX                   128

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SUPPORTED_APIS_CNF_DATA_Ttag
{
  TLR_UINT32                                                aulAvailableAPIs[SIII_MA_CP_GET_SUPPORTED_APIS_MAX];
} __TLR_PACKED_POST SIII_MA_CP_GET_SUPPORTED_APIS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SUPPORTED_APIS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                       tHead;
  SIII_MA_CP_GET_SUPPORTED_APIS_CNF_DATA_T                  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_SUPPORTED_APIS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_SUPPORTED_APIS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                       tHead;
  SIII_MA_CP_GET_SUPPORTED_APIS_REQ_T                       tReq;
  SIII_MA_CP_GET_SUPPORTED_APIS_CNF_T                       tCnf;
} SIII_MA_CP_GET_SUPPORTED_APIS_PCK_T;


/* API designators */
enum SIII_MA_CP_API_DESIGNATORS_Etag
{
  MSK_SIII_MA_CP_API_ID_TYPE                          = 0xFFFF0000,
  MSK_SIII_MA_CP_API_ID_VERSION                       = 0x0000FFFF,

  SIII_MA_CP_API_ID_NEW_PHASE_REQS_AND_INDS           = 0x00010000,    /* new set phase req and phase indications */
  SIII_MA_CP_API_ID_NEW_AUTOCFG_PACKETS               = 0x00020000,    /* new AutoCfg packets within configuration data packets supported */
  SIII_MA_CP_API_ID_HOT_PLUG_PACKETS                  = 0x00030000,
  SIII_MA_CP_API_ID_SELECT_INDICATIONS                = 0x00040000,
  SIII_MA_CP_API_ID_SCP_NRTPC_CONFIGURATION           = 0x00050000,
  SIII_MA_CP_API_ID_SLAVE_DEVICE_RELATIONS            = 0x00060000,
  SIII_MA_CP_API_ID_NEW_AUTOCFG_TIMING_CALCULATION    = 0x00070000,
  SIII_MA_CP_API_ID_REOPEN_CONFIG_PACKETS             = 0x00080000,
  SIII_MA_CP_API_ID_INITCMD_GOTO_JUMPS                = 0x00090000,
  SIII_MA_CP_API_ID_MODIFY_CONFIG_PARAMS              = 0x000A0000
};

/**********************************************************************************************************************

 ######  ##                                       #####              ##     #                               #
  #    #  #                                         #                 #                            #
  #    #  #                                         #                 #                            #
  #    #  # ##    ####    #####   #####             #    ## ##    #####   ###     #####   ####    ####    ###     #####  ## ##    #####
  #####   ##  #       #  #     # #     #            #     ##  #  #    #     #    #     #      #    #        #    #     #  ##  #  #     #
  #       #   #   #####   ###    #######            #     #   #  #    #     #    #        #####    #        #    #     #  #   #   ###
  #       #   #  #    #      ##  #                  #     #   #  #    #     #    #       #    #    #        #    #     #  #   #      ##
  #       #   #  #    #  #     # #     #            #     #   #  #    #     #    #     # #    #    #  #     #    #     #  #   #  #     #
 ####    ### ###  #### #  #####   #####           #####  ### ###  ######  #####   #####   #### #    ##    #####   #####  ### ###  #####


*/

#define SIII_MA_CP_CMD_PHASE_IND                            0x00008904
#define SIII_MA_CP_CMD_PHASE_RES                            0x00008905

/* legacy phase indications { */
#define SIII_MA_CP_CMD_PHASE_NRT_IND                        0x00004830
#define SIII_MA_CP_CMD_PHASE_NRT_RES                        0x00004831

#define SIII_MA_CP_CMD_PHASE_CP0_IND                        0x00004832
#define SIII_MA_CP_CMD_PHASE_CP0_RES                        0x00004833

#define SIII_MA_CP_CMD_PHASE_CP1_IND                        0x00004834
#define SIII_MA_CP_CMD_PHASE_CP1_RES                        0x00004835

#define SIII_MA_CP_CMD_PHASE_CP2_IND                        0x00004836
#define SIII_MA_CP_CMD_PHASE_CP2_RES                        0x00004837

#define SIII_MA_CP_CMD_PHASE_CP3_IND                        0x00004838
#define SIII_MA_CP_CMD_PHASE_CP3_RES                        0x00004839

#define SIII_MA_CP_CMD_PHASE_CP4_IND                        0x0000483A
#define SIII_MA_CP_CMD_PHASE_CP4_RES                        0x0000483B

/* } */

#define SIII_MA_CP_CMD_C1D_DIAGNOSTICS_IND                  0x00004842
#define SIII_MA_CP_CMD_C1D_DIAGNOSTICS_RES                  0x00004843

#define SIII_MA_CP_CMD_C2D_DIAGNOSTICS_IND                  0x00004844
#define SIII_MA_CP_CMD_C2D_DIAGNOSTICS_RES                  0x00004845

#define SIII_MA_CP_CMD_STATE_CHG_STOPPED_IND                0x00004846
#define SIII_MA_CP_CMD_STATE_CHG_STOPPED_RES                0x00004847

#define SIII_MA_CP_CMD_UPDATE_CS_IND                        0x0000484C
#define SIII_MA_CP_CMD_UPDATE_CS_RES                        0x0000484D

#define SIII_MA_CP_CMD_GET_CURRENT_PHASE_REQ                0x0000484E
#define SIII_MA_CP_CMD_GET_CURRENT_PHASE_CNF                0x0000484F


#define SIII_MA_CP_CMD_SLAVES_VALID_IND                     0x0000485E
#define SIII_MA_CP_CMD_SLAVES_VALID_RES                     0x0000485F

#define SIII_MA_CP_CMD_PCA_IND                              0x00008920
#define SIII_MA_CP_CMD_PCA_RES                              0x00008921

#define SIII_MA_CP_CMD_SELECT_INDICATIONS_REQ               0x00008922
#define SIII_MA_CP_CMD_SELECT_INDICATIONS_CNF               0x00008923

/**************************************
 * Reason codes for State Indications
 */
enum SIII_MA_CP_NRT_REASON_Etag
{
  SIII_MA_CP_PHASE_REASON_APP_REQUEST                     = 0x00000000,     /* State changed due to application request */
  SIII_MA_CP_PHASE_REASON_C1D_DIAGNOSIS                   = 0x00000001,     /* State changed due to C1D */
  SIII_MA_CP_PHASE_REASON_BUS_SYNC_ERROR_THRESHOLD        = 0x00000002,     /* State changed due to Bus Sync Error */
  SIII_MA_CP_PHASE_REASON_CHANNEL_INIT                    = 0x00000003,     /* State changed due to Channel Init */
  SIII_MA_CP_PHASE_REASON_BUS_OFF                         = 0x00000004,     /* State changed due to Bus Off */
  SIII_MA_CP_PHASE_REASON_DPM_WATCHDOG                    = 0x00000005,     /* State changed due to DPM watchdog */
  SIII_MA_CP_PHASE_REASON_MDT_NOT_EXCHANGED               = 0x00000006,     /* State changed due to MDT not updated */
  SIII_MA_CP_PHASE_REASON_AT_NOT_EXCHANGED                = 0x00000007,     /* State changed due to AT not updated */
  SIII_MA_CP_PHASE_REASON_FRAME_LOSS                      = 0x00000008,     /* State changed due to frame loss */
  SIII_MA_CP_PHASE_REASON_EXT_TRIGGER_TIMEOUT             = 0x00000009,     /* State changed due to external trigger timeout */
  SIII_MA_CP_PHASE_REASON_EXT_TRIGGER_LOSS                = 0x0000000A,     /* State changed due to external trigger loss */
  SIII_MA_CP_PHASE_REASON_ALL_SLAVES_LOST                 = 0x0000000B,     /* State changed due to all slaves lost */
  SIII_MA_CP_PHASE_REASON_BUS_SCAN_TIMEOUT                = 0x0000000C,     /* State changed due to bus scan timeout */
  SIII_MA_CP_PHASE_REASON_INTERNAL_ERROR                  = 0x0000000D,     /* State changed due to internal error */
};

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_IND/SIII_MA_CP_CMD_PHASE_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_IND_DATA_Ttag
{
  TLR_UINT32                                  ulReason;
  TLR_UINT32                                  ulStackModeFlags;
  TLR_UINT8                                   bCurrentPhase;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_IND_DATA_T                 tData;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_IND_T                      tInd;
  SIII_MA_CP_PHASE_RES_T                      tRes;
} SIII_MA_CP_PHASE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_NRT_IND/SIII_MA_CP_CMD_PHASE_NRT_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_NRT_IND_DATA_Ttag
{
  TLR_UINT32                                  ulReason;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_NRT_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_NRT_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_NRT_IND_DATA_T             tData;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_NRT_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_NRT_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_NRT_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_NRT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_NRT_IND_T                  tInd;
  SIII_MA_CP_PHASE_NRT_RES_T                  tRes;
} SIII_MA_CP_PHASE_NRT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_CP0_IND/SIII_MA_CP_CMD_PHASE_CP0_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP0_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP0_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP0_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP0_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_CP0_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_CP0_IND_T                  tInd;
  SIII_MA_CP_PHASE_CP0_RES_T                  tRes;
} SIII_MA_CP_PHASE_CP0_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_CP1_IND/SIII_MA_CP_CMD_PHASE_CP1_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP1_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP1_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP1_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP1_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_CP1_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_CP1_IND_T                  tInd;
  SIII_MA_CP_PHASE_CP1_RES_T                  tRes;
} SIII_MA_CP_PHASE_CP1_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_CP2_IND/SIII_MA_CP_CMD_PHASE_CP2_RES
 */

typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP2_IND_DATA_Ttag
{
  TLR_UINT32                                  ulStackModeFlags;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP2_IND_DATA_T;

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP2_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_CP2_IND_DATA_T             tData;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP2_IND_T;

enum SIII_MA_CP_PHASE_IND_STACK_MODE_FLAGS_Etag
{
  SIII_MA_CP_STACK_MODE_FLAGS_SLAVES_ADDRESSED_BY_TOPOLOGY_ADDRESS      = (1 << 0),    /* set if unconfigured startup or Bus Scan active */
  SIII_MA_CP_STACK_MODE_FLAGS_SLAVES_BUS_SCAN_ACTIVE                    = (1 << 1)
};

/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP2_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP2_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_CP2_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_CP2_IND_T                  tInd;
  SIII_MA_CP_PHASE_CP2_RES_T                  tRes;
} SIII_MA_CP_PHASE_CP2_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_CP3_IND/SIII_MA_CP_CMD_PHASE_CP3_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP3_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP3_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP3_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP3_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_CP3_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_CP3_IND_T                  tInd;
  SIII_MA_CP_PHASE_CP3_RES_T                  tRes;
} SIII_MA_CP_PHASE_CP3_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PHASE_CP4_IND/SIII_MA_CP_CMD_PHASE_CP4_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP4_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP4_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PHASE_CP4_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_PHASE_CP4_RES_T;


/* packet union */
typedef union SIII_MA_CP_PHASE_CP4_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_PHASE_CP4_IND_T                  tInd;
  SIII_MA_CP_PHASE_CP4_RES_T                  tRes;
} SIII_MA_CP_PHASE_CP4_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SLAVES_VALID_IND/SIII_MA_CP_CMD_SLAVES_VALID_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SLAVES_VALID_IND_DATA_HP_ENTRY_Ttag
{
  TLR_UINT16 usSercosAddress;
  TLR_UINT16 usHotplugStatus; /* see enum SIII_MA_CP_SLAVE_VALID_IND_HP_ENTRY_STATUS_Etag */
} __TLR_PACKED_POST SIII_MA_CP_SLAVES_VALID_IND_DATA_HP_ENTRY_T;

enum SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_Etag
{
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_NO_SLAVE = 0,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_ENABLED = 1,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_BOOTUP_ERROR = 2,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_DUPLICATE_ADDRESS = 3,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_INVALID_ADDRESS = 4,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_UNCONFIGURED_ADDRESS = 5,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_HP1_BEGIN_ERROR = 6,
  SIII_MA_CP_SLAVES_VALID_IND_HP_ENTRY_STATUS_FF_SWITCH_ERROR = 7
};

#define SIII_MA_CP_SLAVES_VALID_NUM_HP_ENTRIES 16

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SLAVES_VALID_IND_DATA_Ttag
{
  TLR_UINT32                                  ulHotPlugStatus;          /* see enum SIII_MA_CP_SLAVES_VALID_IND_HP_STATUS_Etag */
  SIII_MA_CP_SLAVES_VALID_IND_DATA_HP_ENTRY_T atHPEntries[SIII_MA_CP_SLAVES_VALID_NUM_HP_ENTRIES];
  TLR_UINT8                                   abValidSlaves[512 >> 3];  /* bit list of valid slaves i.e. in communication */
  TLR_UINT16                                  usOverallBusStatus;       /* see enum SIII_MA_CP_SLAVES_VALID_IND_OVERALL_BUS_STATUS_Etag */
} __TLR_PACKED_POST SIII_MA_CP_SLAVES_VALID_IND_DATA_T;

enum SIII_MA_CP_SLAVES_VALID_IND_HP_STATUS_Etag
{
  SIII_MA_CP_SLAVES_VALID_IND_HP_STATUS_DISABLED = 0,          /* Hot Plug is disabled */
  SIII_MA_CP_SLAVES_VALID_IND_HP_STATUS_ENABLED = 1,           /* Hot Plug is enabled */
  SIII_MA_CP_SLAVES_VALID_IND_HP_STATUS_ERROR_ACK_REQUIRED = 2 /* Hot Plug is enabled and requires Error Acknowledge / error details in DiagLog */
};

enum SIII_MA_CP_SLAVES_VALID_IND_OVERALL_BUS_STATUS_Etag
{
  SIII_MA_CP_SLAVES_VALID_OVERALL_BUS_STATUS_INACTIVE = 0,
  SIII_MA_CP_SLAVES_VALID_OVERALL_BUS_STATUS_UNCONFIGURED_MODE = 1,
  SIII_MA_CP_SLAVES_VALID_OVERALL_BUS_STATUS_BUS_SCAN = 2,
  SIII_MA_CP_SLAVES_VALID_OVERALL_BUS_STATUS_AT_LEAST_ONE_SLAVE_MISSING = 3,
  SIII_MA_CP_SLAVES_VALID_OVERALL_BUS_STATUS_ALL_SLAVES_ACTIVE = 4
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SLAVES_VALID_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_CP_SLAVES_VALID_IND_DATA_T      tData;
} __TLR_PACKED_POST SIII_MA_CP_SLAVES_VALID_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SLAVES_VALID_RES_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
} __TLR_PACKED_POST SIII_MA_CP_SLAVES_VALID_RES_T;


/* packet union */
typedef union SIII_MA_CP_SLAVES_VALID_PCK_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_CP_SLAVES_VALID_IND_T         tInd;
  SIII_MA_CP_SLAVES_VALID_RES_T         tRes;
} SIII_MA_CP_SLAVES_VALID_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_C1D_DIAGNOSTICS_IND/SIII_MA_CP_CMD_C1D_DIAGNOSTICS_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_C1D_DIAGNOSTICS_IND_DATA_Ttag
{
  TLR_UINT8                                   abDiagnosticsActive[512 >> 3];   //Bit list (one bit per slave)
} __TLR_PACKED_POST SIII_MA_CP_C1D_DIAGNOSTICS_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_C1D_DIAGNOSTICS_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_C1D_DIAGNOSTICS_IND_DATA_T       tData;
} __TLR_PACKED_POST SIII_MA_CP_C1D_DIAGNOSTICS_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_C1D_DIAGNOSTICS_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_C1D_DIAGNOSTICS_RES_T;


/* packet union */
typedef union SIII_MA_CP_C1D_DIAGNOSTICS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_C1D_DIAGNOSTICS_IND_T            tInd;
  SIII_MA_CP_C1D_DIAGNOSTICS_RES_T            tRes;
} SIII_MA_CP_C1D_DIAGNOSTICS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_C2D_DIAGNOSTICS_IND/SIII_MA_CP_CMD_C2D_DIAGNOSTICS_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_C2D_DIAGNOSTICS_IND_DATA_Ttag
{
  TLR_UINT8                                   abDiagnosticsActive[512 >> 3];   //Bit list (one bit per slave)
} __TLR_PACKED_POST SIII_MA_CP_C2D_DIAGNOSTICS_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_C2D_DIAGNOSTICS_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_C2D_DIAGNOSTICS_IND_DATA_T       tData;
} __TLR_PACKED_POST SIII_MA_CP_C2D_DIAGNOSTICS_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_C2D_DIAGNOSTICS_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_C2D_DIAGNOSTICS_RES_T;


/* packet union */
typedef union SIII_MA_CP_C2D_DIAGNOSTICS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_C2D_DIAGNOSTICS_IND_T            tInd;
  SIII_MA_CP_C2D_DIAGNOSTICS_RES_T            tRes;
} SIII_MA_CP_C2D_DIAGNOSTICS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_UPDATE_CS_IND/SIII_MA_CP_CMD_UPDATE_CS_RES
 *
 *          Updates Common Status (Master Implementation part)
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_UPDATE_CS_IND_DATA_Ttag
{
  /** Number of configured slaves */
  TLR_UINT32                          ulNumOfConfigSlaves;
  /** Number of active slaves */
  TLR_UINT32                          ulNumOfActiveSlaves;
  /** Number of slaves in diag mode */
  TLR_UINT32                          ulNumOfDiagSlaves;
  /** Configured slaves bit list */
  TLR_UINT8                           abConfiguredSlaves[512 / 8];
  /** Active slaves bit list */
  TLR_UINT8                           abActiveSlaves[512 / 8];
  /** Faulted slaves bit list */
  TLR_UINT8                           abFaultedSlaves[512 / 8];
} __TLR_PACKED_POST SIII_MA_CP_UPDATE_CS_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_UPDATE_CS_IND_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_CP_UPDATE_CS_IND_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_UPDATE_CS_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_UPDATE_CS_RES_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
} __TLR_PACKED_POST SIII_MA_CP_UPDATE_CS_RES_T;


/* packet union */
typedef union SIII_MA_CP_UPDATE_CS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_UPDATE_CS_IND_T                  tInd;
  SIII_MA_CP_UPDATE_CS_RES_T                  tRes;
} SIII_MA_CP_UPDATE_CS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_STATE_CHG_STOPPED_IND/SIII_MA_CP_CMD_STATE_CHG_STOPPED_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_STATE_CHG_STOPPED_IND_DATA_Ttag
{
  TLR_UINT16                                  usReasonCode;
  TLR_UINT8                                   abSlaveOkayList[512 >> 3]; //Bit list (one bit per slave) (all non-existent and all error-signalling slaves have a 0 in here */
} __TLR_PACKED_POST SIII_MA_CP_STATE_CHG_STOPPED_IND_DATA_T;

enum SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODEtag
{
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_NO_ERROR                                 = 0x0000, /* this is used for SIII_MA_CP_CMD_GET_CURRENT_PHASE_CNF */
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CPX_CP0_DEV_STATUS_INVALID_TIMEOUT       = 0x0001,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP1_CP2_DEV_STATUS_INVALID_TIMEOUT       = 0x0002,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP2_CP3_DEV_STATUS_INVALID_TIMEOUT       = 0x0003,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP3_CP4_DEV_STATUS_INVALID_TIMEOUT       = 0x0004,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP1_DEV_STATUS_VALID_TIMEOUT             = 0x0005,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP2_DEV_STATUS_VALID_TIMEOUT             = 0x0006,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP3_DEV_STATUS_VALID_TIMEOUT             = 0x0007,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP4_DEV_STATUS_VALID_TIMEOUT             = 0x0008,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP3_TIMING_CONFIGURATION_ERROR           = 0x0009,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CP0_CP1_TOPO_ADDR_INVALID_TIMEOUT        = 0x000A,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CONN_LENGTH_ERROR                        = 0x000B,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_S_0_127_COMMAND_ERROR                    = 0x000C,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_S_0_128_COMMAND_ERROR                    = 0x000D,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_S_0_1024_COMMAND_ERROR                   = 0x000E,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_INITCMD_ERROR                            = 0x000F,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_CONN_LENGTH_READ_ERROR                   = 0x0010,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_S_0_99_COMMAND_ERROR                     = 0x0011,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SVCH_ERROR                               = 0x0012,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_DEVICE_IDENT_MISMATCH                    = 0x0013,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_S_0_1048_0_0_COMMAND_ERROR               = 0x0014,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SCP_NRT_PARAM_ERROR                      = 0x0015,

  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP0_ERROR                      = 0xF000,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP1_ERROR                      = 0xF001,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP2_ERROR                      = 0xF002,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP3_ERROR                      = 0xF003,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP4_ERROR                      = 0xF004,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP0S_ERROR                     = 0xF005,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP1S_ERROR                     = 0xF006,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP2S_ERROR                     = 0xF007,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP3S_ERROR                     = 0xF008,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SET_PHASE_CP4S_ERROR                     = 0xF009,
  SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODE_SVC_TASK_COMMUNICATION_ERROR             = 0xF00A,
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_STATE_CHG_STOPPED_IND_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_STATE_CHG_STOPPED_IND_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_STATE_CHG_STOPPED_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_STATE_CHG_STOPPED_RES_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_STATE_CHG_STOPPED_RES_T;


/* packet union */
typedef union SIII_MA_CP_STATE_CHG_STOPPED_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_STATE_CHG_STOPPED_IND_T          tInd;
  SIII_MA_CP_STATE_CHG_STOPPED_RES_T          tRes;
} SIII_MA_CP_STATE_CHG_STOPPED_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CURRENT_PHASE_REQ/SIII_MA_CP_CMD_GET_CURRENT_PHASE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CURRENT_PHASE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_CURRENT_PHASE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CURRENT_PHASE_CNF_DATA_Ttag
{
  TLR_UINT8                                   bCurrentPhase;
  TLR_UINT8                                   bTargetPhase;
  TLR_UINT32                                  ulStopReason;   /* uses enumeration SIII_MA_CP_STATE_CHG_STOPPED_REASON_CODEtag */
  TLR_UINT32                                  ulNrtReason;    /* uses SIII_MA_CP_PHASE_REASON_* defines, only valid if bCurrentPhase is NRT(0x7F) */
  TLR_UINT8                                   abFailedSlaves[512 >> 3];
  TLR_UINT32                                  ulStackModeFlags;   /* uses SIII_MA_CP_STACK_MODE_FLAGS_* defines */
} __TLR_PACKED_POST SIII_MA_CP_GET_CURRENT_PHASE_CNF_DATA_T;

/* value enumeration for bCurrentPhase and bTargetPhase */
enum SIII_MA_CP_PHASE_Etag
{
  SIII_MA_CP_PHASE_IS_NRT                   = 0x7F,
  SIII_MA_CP_PHASE_IS_CP0                   = 0x00,
  SIII_MA_CP_PHASE_IS_CP1                   = 0x01,
  SIII_MA_CP_PHASE_IS_CP2                   = 0x02,
  SIII_MA_CP_PHASE_IS_CP3                   = 0x03,
  SIII_MA_CP_PHASE_IS_CP4                   = 0x04
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CURRENT_PHASE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_GET_CURRENT_PHASE_CNF_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CURRENT_PHASE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_CURRENT_PHASE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_GET_CURRENT_PHASE_REQ_T          tReq;
  SIII_MA_CP_GET_CURRENT_PHASE_CNF_T          tCnf;
} SIII_MA_CP_GET_CURRENT_PHASE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_PCA_IND/SIII_MA_CP_CMD_PCA_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PCA_IND_DATA_Ttag
{
  TLR_UINT8 abPcaActive[512 / 8];
} __TLR_PACKED_POST SIII_MA_CP_PCA_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_PCA_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_PCA_IND_DATA_T                 tData;
} __TLR_PACKED_POST SIII_MA_CP_PCA_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_PCA_RES_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_PCA_RES_T;


/* packet union */
typedef union SIII_MA_CP_PCA_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_PCA_IND_T                      tInd;
  SIII_MA_CP_PCA_RES_T                      tRes;
} SIII_MA_CP_PCA_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SELECT_INDICATIONS_REQ/SIII_MA_CP_CMD_SELECT_INDICATIONS_CNF
 *
 * selects indications registered by RCX_REGISTER_APP_REQ
 */

/**************************************/
/* indication flags [0-7] */
#define SIII_MA_CP_NUM_SETS_OF_INDICATION_FLAGS 8

/* indicationflags[0] */
#define MSK_SIII_MA_CP_IND_0_FLAG_OLD_PHASE                 0x00000001
#define MSK_SIII_MA_CP_IND_0_FLAG_NEW_PHASE                 0x00000002
#define MSK_SIII_MA_CP_IND_0_FLAG_STATE_CHG_STOPPED         0x00000004
#define MSK_SIII_MA_CP_IND_0_FLAG_C1D_DIAGNOSTICS           0x00000008
#define MSK_SIII_MA_CP_IND_0_FLAG_C2D_DIAGNOSTICS           0x00000010
#define MSK_SIII_MA_CP_IND_0_FLAG_UPDATE_CS                 0x00000020
#define MSK_SIII_MA_CP_IND_0_FLAG_SLAVES_VALID              0x00000040
#define MSK_SIII_MA_CP_IND_0_FLAG_PCA                       0x00000080  /* Procedure Command Acknowledge */
#define MSK_SIII_MA_CP_IND_0_FLAG_CP0_SLAVE_STATES          0x00000100


/**************************************/
/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SELECT_INDICATIONS_REQ_DATA_Ttag
{
  TLR_UINT32 aulEnableIndicationFlags[SIII_MA_CP_NUM_SETS_OF_INDICATION_FLAGS];
  TLR_UINT32 aulDisableIndicationFlags[SIII_MA_CP_NUM_SETS_OF_INDICATION_FLAGS];
  TLR_BOOLEAN32 fReplaceEnabledFlags;
} __TLR_PACKED_POST SIII_MA_CP_SELECT_INDICATIONS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SELECT_INDICATIONS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SELECT_INDICATIONS_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_SELECT_INDICATIONS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SELECT_INDICATIONS_CNF_DATA_Ttag
{
  TLR_UINT32 aulEnabledIndicationFlags[SIII_MA_CP_NUM_SETS_OF_INDICATION_FLAGS];
} __TLR_PACKED_POST SIII_MA_CP_SELECT_INDICATIONS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SELECT_INDICATIONS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SELECT_INDICATIONS_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_SELECT_INDICATIONS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SELECT_INDICATIONS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SELECT_INDICATIONS_REQ_T       tReq;
  SIII_MA_CP_SELECT_INDICATIONS_CNF_T       tCnf;
} SIII_MA_CP_SELECT_INDICATIONS_PCK_T;


/**********************************************************************************************************************

 #####      #                                                       #                    #####
  #   #                                                    #                               #
  #    #                                                   #                               #
  #    #  ###     ####    ###### ## ##    #####   #####   ####    ###     #####            #      #####   ######
  #    #    #         #  #    #   ##  #  #     # #     #   #        #    #     #           #     #     # #    #
  #    #    #     #####  #    #   #   #  #     #  ###      #        #    #                 #     #     # #    #
  #    #    #    #    #  #    #   #   #  #     #     ##    #        #    #                 #     #     # #    #
  #   #     #    #    #   #####   #   #  #     # #     #   #  #     #    #     #           #   # #     #  #####
 #####    #####   #### #      #  ### ###  #####   #####     ##    #####   #####          #######  #####       #
                              #                                                                               #
                          ####                                                                            ####

*/

#define SIII_MA_CP_CMD_READ_DIAG_LOG_ENTRY_REQ          0x00004860
#define SIII_MA_CP_CMD_READ_DIAG_LOG_ENTRY_CNF          0x00004861

#define SIII_MA_CP_CMD_CLEAR_DIAG_LOG_REQ               0x00004862
#define SIII_MA_CP_CMD_CLEAR_DIAG_LOG_CNF               0x00004863

#define SIII_MA_CP_CMD_NEW_DIAG_LOG_ENTRIES_IND         0x00004864
#define SIII_MA_CP_CMD_NEW_DIAG_LOG_ENTRIES_RES         0x00004865

#define SIII_MA_CP_CMD_DIAG_INDICATIONS_REGISTER_REQ    0x00004866
#define SIII_MA_CP_CMD_DIAG_INDICATIONS_REGISTER_CNF    0x00004867

#define SIII_MA_CP_CMD_DIAG_INDICATIONS_UNREGISTER_REQ  0x00004868
#define SIII_MA_CP_CMD_DIAG_INDICATIONS_UNREGISTER_CNF  0x00004869

/******************************************************************************
 * Diagnostic Entry Structure
 */

typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_HEADER_Ttag
{
  TLR_UINT16                                        usEntryType;
  TLR_UINT32                                        ulTimestampS;
  TLR_UINT32                                        ulTimestampNs;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_HEADER_T;

/* Entry Type: 0x0000 is reserved for no data */
enum SIII_MA_CP_DIAG_ENTRY_TYPE_Etag
{
  VAL_CP_DIAG_ENTRY_TYPE_NEW_CP                           = 0x0001,
  VAL_CP_DIAG_ENTRY_TYPE_INITCMD_FAILED                   = 0x0002,
  VAL_CP_DIAG_ENTRY_TYPE_SLAVE_FAILED                     = 0x0003,
  VAL_CP_DIAG_ENTRY_TYPE_BUS_ON                           = 0x0004,
  VAL_CP_DIAG_ENTRY_TYPE_BUS_OFF                          = 0x0005,
  VAL_CP_DIAG_ENTRY_TYPE_CHANNEL_INIT                     = 0x0006,
  VAL_CP_DIAG_ENTRY_TYPE_DPM_WATCHDOG                     = 0x0007,
  VAL_CP_DIAG_ENTRY_TYPE_TOPOLOGY_CHANGED                 = 0x0008,
  VAL_CP_DIAG_ENTRY_TYPE_SLAVE_HOTPLUG_ENABLED            = 0x0009,
  VAL_CP_DIAG_ENTRY_TYPE_SLAVE_HOTPLUG_ABORTED            = 0x000A,
  VAL_CP_DIAG_ENTRY_TYPE_SLAVE_HOTPLUG_COMPLETED          = 0x000B,
  VAL_CP_DIAG_ENTRY_TYPE_SLAVE_WARNING                    = 0x000C,
  VAL_CP_DIAG_ENTRY_TYPE_RING_DELAY_MEASURE_TOPO_CHANGED  = 0x000D,
  VAL_CP_DIAG_ENTRY_TYPE_TOPO_CHANGED_WITHOUT_REQUEST     = 0x000E,    /* WARNING! that slave changed topology to FF without request */
  VAL_CP_DIAG_ENTRY_TYPE_TOPO_CHANGE_REQUEST_ABORTED      = 0x000F,
  VAL_CP_DIAG_ENTRY_TYPE_TOPO_CHANGE_REQUEST_DENIED       = 0x0010,
  VAL_CP_DIAG_ENTRY_TYPE_SLAVE_TOPOLOGY_CHANGED           = 0x0011,
  VAL_CP_DIAG_ENTRY_TYPE_INTERNAL_ERROR                   = 0x0012,
  VAL_CP_DIAG_ENTRY_TYPE_S_0_1050_X_5_CONN_LENGTH_ERROR   = 0x0013,
  VAL_CP_DIAG_ENTRY_TYPE_BUS_SCAN_REQUESTED               = 0x0014,
  VAL_CP_DIAG_ENTRY_TYPE_EXT_TRIGGER_TIMEOUT              = 0x0015,
  VAL_CP_DIAG_ENTRY_TYPE_EXT_TRIGGER_LOSS                 = 0x0016,
  VAL_CP_DIAG_ENTRY_TYPE_ALL_SLAVES_LOST                  = 0x0017,
  VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_UNKNOWN_SERCOS_ADDRESS   = 0x0018,
  VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_DUPLICATE_SERCOS_ADDRESS = 0x0019,
  VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_INVALID_SERCOS_ADDRESS   = 0x001A,
  VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_UNCONF_SERCOS_ADDRESS    = 0x001B,
  VAL_CP_DIAG_ENTRY_TYPE_TOPO_ADDR_INFO_INCONSISTENT      = 0x001C,
  VAL_CP_DIAG_ENTRY_TYPE_FF_DIAG                          = 0x001D,
  VAL_CP_DIAG_ENTRY_TYPE_HP1_BEGIN_ERROR                  = 0x001E,
};

/* used by type:
 * - VAL_CP_DIAG_ENTRY_TYPE_NEW_CP
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_NEW_CP_Ttag
{
  TLR_UINT8             bPhase;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_NEW_CP_T;

/* used by type:
 * - VAL_CP_DIAG_ENTRY_TYPE_INITCMD_FAILED
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_INITCMD_FAILED_Ttag
{
  TLR_UINT16                                        usTopologyAddress;  /* not valid if set to ZERO, otherwise it refers to topology address */
  TLR_UINT16                                        usSercosAddress;
  TLR_UINT32                                        ulIDN;
  TLR_UINT16                                        usErrorReason;
  TLR_UINT16                                        usSvchError;
  TLR_UINT16                                        usSlFsmState;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_INITCMD_FAILED_T;

enum SIII_MA_CP_DIAG_ENTRY_INITCMD_ERROR_REASON_Etag
{
  VAL_CP_DIAG_ENTRY_INITCMD_ERROR_REASON_WRITE_FAILED             = 0x0001,
  VAL_CP_DIAG_ENTRY_INITCMD_ERROR_REASON_READ_FAILED              = 0x0002,
  VAL_CP_DIAG_ENTRY_INITCMD_ERROR_REASON_COMPARE_DATA_FAILED      = 0x0003,
  VAL_CP_DIAG_ENTRY_INITCMD_ERROR_REASON_SVC_TASK_FAILED          = 0x0004,
  VAL_CP_DIAG_ENTRY_INITCMD_ERROR_REASON_COMMAND_FAILED           = 0x0005
};

/* used by type:
 * - VAL_CP_DIAG_ENTRY_TYPE_SLAVE_FAILED
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_SLAVE_FAILED_Ttag
{
  TLR_UINT16                                        usTopologyAddress;  /* not valid if set to ZERO, otherwise it refers to topology address */
  TLR_UINT16                                        usSercosAddress;
  TLR_UINT16                                        usErrorReason;
  TLR_UINT16                                        usSvchError;
  TLR_UINT16                                        usSlFsmState;
  TLR_UINT32                                        ulIDN;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_SLAVE_FAILED_T;

enum SIII_MA_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_Etag
{
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_LOST_LINK                  = 0x0001,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_DEV_STATUS_INVALID_TIMEOUT = 0x0002,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_DEV_STATUS_VALID_TIMEOUT   = 0x0003,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_SVC_TASK_FAILED            = 0x0004,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_SLAVE_SVC_FAILED           = 0x0005,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_MHS_AHS_TIMEOUT            = 0x0006,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_BUSY_TIMEOUT               = 0x0007,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_127_COMMAND_ERROR      = 0x0008,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_128_COMMAND_ERROR      = 0x0009,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_SLAVE_NOT_CONFIGURED       = 0x000A,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_SLAVE_IS_MISSING           = 0x000B,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_1024_COMMAND_ERROR     = 0x000C,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_DUPLICATE_SERCOS_ADDRESS   = 0x000D,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_INVALID_SERCOS_ADDRESS     = 0x000E,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_99_COMMAND_ERROR       = 0x000F,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_0021_IDN_LIST          = 0x0010,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_0022_IDN_LIST          = 0x0011,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_1050_X_6_WRONG_IDN     = 0x0012,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_DEVICE_IDENT_MISMATCH      = 0x0013,
  VAL_CP_DIAG_ENTRY_SLAVE_ERROR_REASON_S_0_1048_0_0_COMMAND_ERROR = 0x0014,
};

/* used by type:
 * - VAL_CP_DIAG_ENTRY_TYPE_SLAVE_WARNING
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_SLAVE_WARNING_Ttag
{
  TLR_UINT16                                        usTopologyAddress;  /* not valid if set to ZERO, otherwise it refers to topology address */
  TLR_UINT16                                        usSercosAddress;
  TLR_UINT16                                        usWarningReason;
  TLR_UINT16                                        usSvchError;
  TLR_UINT16                                        usSlFsmState;
  TLR_UINT32                                        ulIDN;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_SLAVE_WARNING_T;

#define VAL_CP_DIAG_ENTRY_SLAVE_WARNING_REASON_PROC_CMD_ACK_MISSING     0x0001

/* used by type:
 * - VAL_CP_DIAG_ENTRY_TYPE_TOPOLOGY_CHANGED
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_TOPOLOGY_CHANGED_Ttag
{
  TLR_BOOLEAN8                                      fRingBroken;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_TOPOLOGY_CHANGED_T;


/* used by types:
 * - VAL_CP_DIAG_ENTRY_TYPE_SLAVE_HOTPLUG_ENABLED
 * - VAL_CP_DIAG_ENTRY_TYPE_SLAVE_HOTPLUG_ABORTED
 * - VAL_CP_DIAG_ENTRY_TYPE_SLAVE_HOTPLUG_COMPLETED
 * - VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_UNKNOWN_SERCOS_ADDRESS
 * - VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_DUPLICATE_SERCOS_ADDRESS
 * - VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_INVALID_SERCOS_ADDRESS
 * - VAL_CP_DIAG_ENTRY_TYPE_HOTPLUG_UNCONF_SERCOS_ADDRESS
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_SLAVE_HOTPLUG_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_SLAVE_HOTPLUG_T;

/* used by types:
 * - VAL_CP_DIAG_ENTRY_TYPE_TOPO_CHANGED_WITHOUT_REQUEST
 * - VAL_CP_DIAG_ENTRY_TYPE_TOPO_CHANGE_REQUEST_DENIED
 * - VAL_CP_DIAG_ENTRY_TYPE_SLAVE_TOPOLOGY_CHANGED
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_SLAVE_TOPOLOGY_CHANGED_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_SLAVE_TOPOLOGY_CHANGED_T;

/* used by types:
 * - VAL_CP_DIAG_ENTRY_TYPE_TOPO_CHANGE_REQUEST_ABORTED
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_SLAVE_TOPOLOGY_CHANGE_ABORTED_Ttag
{
  TLR_UINT16                                        usSlaveAddress1;
  TLR_UINT16                                        usSlaveAddress2;
  TLR_UINT32                                        ulLldError;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_SLAVE_TOPOLOGY_CHANGE_ABORTED_T;

/* used by types:
 * - VAL_CP_DIAG_ENTRY_TYPE_INTERNAL_ERROR
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_INTERNAL_ERROR_Ttag
{
  TLR_UINT32                                        ulFunctionId;
  TLR_UINT32                                        ulErrorCode;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_INTERNAL_ERROR_T;

/* used by types:
 * - VAL_CP_DIAG_ENTRY_TYPE_S_0_1050_X_5_CONN_LENGTH_ERROR
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_S_0_1050_X_5_CONN_LENGTH_ERROR_Ttag
{
  TLR_UINT16                                        usTopologyAddress;  /* not valid if set to ZERO, otherwise it refers to topology address */
  TLR_UINT16                                        usSercosAddress;
  TLR_UINT8                                         bConnectionInstance;
  TLR_UINT16                                        usMasterSideConnectionLength;
  TLR_UINT16                                        usSlaveSideConnectionLength;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_S_0_1050_X_5_CONN_LENGTH_ERROR_T;

/* used by type:
 * - VAL_CP_DIAG_ENTRY_TYPE_FF_DIAG
 */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_FF_DIAG_Ttag
{
  TLR_UINT16                                        usStatus;
  TLR_UINT16                                        usSlaveAddressAtEnd;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_FF_DIAG_T;

enum SIII_MA_CP_DIAG_ENTRY_FF_DIAG_STATUS_Etag
{
  VAL_CP_DIAG_ENTRY_FF_DIAG_NO_ERROR                = 0,
  VAL_CP_DIAG_ENTRY_FF_DIAG_TRIGGERED               = 1,
  VAL_CP_DIAG_ENTRY_FF_DIAG_SOLVABLE_P_ERROR        = 2,
  VAL_CP_DIAG_ENTRY_FF_DIAG_SOLVABLE_S_ERROR        = 3,
  VAL_CP_DIAG_ENTRY_FF_DIAG_UNSOLVABLE_P_ERROR      = 4,
  VAL_CP_DIAG_ENTRY_FF_DIAG_UNSOLVABLE_S_ERROR      = 5,
};


typedef __TLR_PACKED_PRE union SIII_MA_CP_DIAG_ENTRY_DATA_Ttag
{
  SIII_MA_CP_DIAG_ENTRY_NEW_CP_T                          tNewCP;
  SIII_MA_CP_DIAG_ENTRY_INITCMD_FAILED_T                  tInitCmdFailed;
  SIII_MA_CP_DIAG_ENTRY_SLAVE_FAILED_T                    tSlaveFailed;
  SIII_MA_CP_DIAG_ENTRY_SLAVE_WARNING_T                   tSlaveWarning;
  SIII_MA_CP_DIAG_ENTRY_TOPOLOGY_CHANGED_T                tTopologyChanged;
  SIII_MA_CP_DIAG_ENTRY_SLAVE_HOTPLUG_T                   tSlaveHotplug;
  SIII_MA_CP_DIAG_ENTRY_SLAVE_TOPOLOGY_CHANGED_T          tSlaveTopologyChanged;
  SIII_MA_CP_DIAG_ENTRY_SLAVE_TOPOLOGY_CHANGE_ABORTED_T   tSlaveTopologyChangeAborted;
  SIII_MA_CP_DIAG_ENTRY_INTERNAL_ERROR_T                  tInternalError;
  SIII_MA_CP_DIAG_ENTRY_S_0_1050_X_5_CONN_LENGTH_ERROR_T  tConnLengthError;
  SIII_MA_CP_DIAG_ENTRY_FF_DIAG_T                         tFFDiagInfo;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_ENTRY_Ttag
{
  SIII_MA_CP_DIAG_ENTRY_HEADER_T                    tHead;
  SIII_MA_CP_DIAG_ENTRY_DATA_T                      tData;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_ENTRY_T;

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_READ_DIAG_LOG_ENTRY_REQ/SIII_MA_CP_CMD_READ_DIAG_LOG_ENTRY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_READ_DIAG_LOG_ENTRY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_READ_DIAG_LOG_ENTRY_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_READ_DIAG_LOG_ENTRY_CNF_DATA_Ttag
{
  TLR_UINT32                                        ulLostEntries;
  SIII_MA_CP_DIAG_ENTRY_T                           tDiagEntry;
} __TLR_PACKED_POST SIII_MA_CP_READ_DIAG_LOG_ENTRY_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_READ_DIAG_LOG_ENTRY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_READ_DIAG_LOG_ENTRY_CNF_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_READ_DIAG_LOG_ENTRY_CNF_T;


/* packet union */
typedef union SIII_MA_CP_READ_DIAG_LOG_ENTRY_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_READ_DIAG_LOG_ENTRY_REQ_T              tReq;
  SIII_MA_CP_READ_DIAG_LOG_ENTRY_CNF_T              tCnf;
} SIII_MA_CP_READ_DIAG_LOG_ENTRY_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CLEAR_DIAG_LOG_REQ/SIII_MA_CP_CMD_CLEAR_DIAG_LOG_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CLEAR_DIAG_LOG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_CLEAR_DIAG_LOG_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CLEAR_DIAG_LOG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_CLEAR_DIAG_LOG_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CLEAR_DIAG_LOG_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_CLEAR_DIAG_LOG_REQ_T             tReq;
  SIII_MA_CP_CLEAR_DIAG_LOG_CNF_T             tCnf;
} SIII_MA_CP_CLEAR_DIAG_LOG_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_NEW_DIAG_LOG_ENTRIES_IND/SIII_MA_CP_CMD_NEW_DIAG_LOG_ENTRIES_RES
 */

/* indication packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_IND_DATA_Ttag
{
  TLR_UINT16                                        usNumOfDiagEntries;
} __TLR_PACKED_POST SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_IND_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_IND_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_IND_T;


/* response packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_RES_T;


/* packet union */
typedef union SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_IND_T       tInd;
  SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_RES_T       tRes;
} SIII_MA_CP_NEW_DIAG_LOG_ENTRIES_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_DIAG_INDICATIONS_REGISTER_REQ/SIII_MA_CP_CMD_DIAG_INDICATIONS_REGISTER_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_INDICATIONS_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_INDICATIONS_REGISTER_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_INDICATIONS_REGISTER_CNF_DATA_Ttag
{
  TLR_UINT16                                        usNumOfDiagEntries;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_INDICATIONS_REGISTER_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_INDICATIONS_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_DIAG_INDICATIONS_REGISTER_CNF_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_INDICATIONS_REGISTER_CNF_T;


/* packet union */
typedef union SIII_MA_CP_DIAG_INDICATIONS_REGISTER_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_DIAG_INDICATIONS_REGISTER_REQ_T        tReq;
  SIII_MA_CP_DIAG_INDICATIONS_REGISTER_CNF_T        tCnf;
} SIII_MA_CP_DIAG_INDICATIONS_REGISTER_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_DIAG_INDICATIONS_UNREGISTER_REQ/SIII_MA_CP_CMD_DIAG_INDICATIONS_UNREGISTER_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_CNF_T;


/* packet union */
typedef union SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_REQ_T      tReq;
  SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_CNF_T      tCnf;
} SIII_MA_CP_DIAG_INDICATIONS_UNREGISTER_PCK_T;


/**********************************************************************************************************************

  #####                             #              ##              ####                                              ##
 #     #                                            #             #    #                                              #
 #                                                  #            #                                                    #
 #       ######   #####   #####   ###     ####      #            #        #####  ### #   ### #    ####   ## ##    #####   #####
  #####   #    # #     # #     #    #         #     #            #       #     #  # # #   # # #       #   ##  #  #    #  #     #
       #  #    # ####### #          #     #####     #            #       #     #  # # #   # # #   #####   #   #  #    #   ###
       #  #    # #       #          #    #    #     #            #       #     #  # # #   # # #  #    #   #   #  #    #      ##
 #     #  #    # #     # #     #    #    #    #     #             #    # #     #  # # #   # # #  #    #   #   #  #    #  #     #
  #####   #####   #####   #####   #####   #### #  #####            ####   #####  ## # ## ## # ##  #### # ### ###  ######  #####
          #
         ###

*/

#define SIII_MA_CP_CMD_SET_IDENT_REQ_BIT_REQ                0x00004850
#define SIII_MA_CP_CMD_SET_IDENT_REQ_BIT_CNF                0x00004851

#define SIII_MA_CP_CMD_CLR_IDENT_REQ_BIT_REQ                0x00004852
#define SIII_MA_CP_CMD_CLR_IDENT_REQ_BIT_CNF                0x00004853

#define SIII_MA_CP_CMD_SET_RING_HEALING_TO_MANUAL_REQ       0x00004854
#define SIII_MA_CP_CMD_SET_RING_HEALING_TO_MANUAL_CNF       0x00004855

#define SIII_MA_CP_CMD_SET_RING_HEALING_TO_AUTO_REQ         0x00004856
#define SIII_MA_CP_CMD_SET_RING_HEALING_TO_AUTO_CNF         0x00004857

#define SIII_MA_CP_CMD_REQUEST_RING_HEALING_REQ             0x00004858
#define SIII_MA_CP_CMD_REQUEST_RING_HEALING_CNF             0x00004859

#define SIII_MA_CP_CMD_CHECK_RING_STATUS_REQ                0x0000485A
#define SIII_MA_CP_CMD_CHECK_RING_STATUS_CNF                0x0000485B

#define SIII_MA_CP_CMD_RING_STATUS_IND                      0x0000485C /* reserved for future */
#define SIII_MA_CP_CMD_RING_STATUS_RES                      0x0000485D

#define SIII_MA_CP_CMD_ACKNOWLEDGE_HOT_PLUG_ERROR_REQ       0x0000891C
#define SIII_MA_CP_CMD_ACKNOWLEDGE_HOT_PLUG_ERROR_CNF       0x0000891D


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ACKNOWLEDGE_HOT_PLUG_ERROR_REQ/SIII_MA_CP_CMD_ACKNOWLEDGE_HOT_PLUG_ERROR_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_REQ_T tReq;
  SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_CNF_T tCnf;
} SIII_MA_CP_ACKNOWLEDGE_HOT_PLUG_ERROR_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_IDENT_REQ_BIT_REQ/SIII_MA_CP_CMD_SET_IDENT_REQ_BIT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_IDENT_REQ_BIT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_IDENT_REQ_BIT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_IDENT_REQ_BIT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_T        tReq;
  SIII_MA_CP_SET_IDENT_REQ_BIT_CNF_T        tCnf;
} SIII_MA_CP_SET_IDENT_REQ_BIT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CLR_IDENT_REQ_BIT_REQ/SIII_MA_CP_CMD_CLR_IDENT_REQ_BIT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CLR_IDENT_REQ_BIT_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_CLR_IDENT_REQ_BIT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CLR_IDENT_REQ_BIT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SET_IDENT_REQ_BIT_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_CLR_IDENT_REQ_BIT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CLR_IDENT_REQ_BIT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_CLR_IDENT_REQ_BIT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CLR_IDENT_REQ_BIT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_CLR_IDENT_REQ_BIT_REQ_T        tReq;
  SIII_MA_CP_CLR_IDENT_REQ_BIT_CNF_T        tCnf;
} SIII_MA_CP_CLR_IDENT_REQ_BIT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_RING_HEALING_TO_MANUAL_REQ/SIII_MA_CP_CMD_SET_RING_HEALING_TO_MANUAL_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_REQ_T tReq;
  SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_CNF_T tCnf;
} SIII_MA_CP_SET_RING_HEALING_TO_MANUAL_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_RING_HEALING_TO_AUTO_REQ/SIII_MA_CP_CMD_SET_RING_HEALING_TO_AUTO_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_RING_HEALING_TO_AUTO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_RING_HEALING_TO_AUTO_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_RING_HEALING_TO_AUTO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_RING_HEALING_TO_AUTO_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_RING_HEALING_TO_AUTO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_SET_RING_HEALING_TO_AUTO_REQ_T tReq;
  SIII_MA_CP_SET_RING_HEALING_TO_AUTO_CNF_T tCnf;
} SIII_MA_CP_SET_RING_HEALING_TO_AUTO_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_REQUEST_RING_HEALING_REQ/SIII_MA_CP_CMD_REQUEST_RING_HEALING_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_REQUEST_RING_HEALING_REQ_DATA_Ttag
{
  TLR_UINT16                                usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_REQUEST_RING_HEALING_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_REQUEST_RING_HEALING_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_REQUEST_RING_HEALING_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_REQUEST_RING_HEALING_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_REQUEST_RING_HEALING_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_REQUEST_RING_HEALING_CNF_T;


/* packet union */
typedef union SIII_MA_CP_REQUEST_RING_HEALING_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_REQUEST_RING_HEALING_REQ_T     tReq;
  SIII_MA_CP_REQUEST_RING_HEALING_CNF_T     tCnf;
} SIII_MA_CP_REQUEST_RING_HEALING_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CHECK_RING_STATUS_REQ/SIII_MA_CP_CMD_CHECK_RING_STATUS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CHECK_RING_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_CHECK_RING_STATUS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CHECK_RING_STATUS_CNF_DATA_Ttag
{
  TLR_UINT16                                usRingStatus;
  TLR_UINT16                                usPLineSercosAddress;
  TLR_UINT16                                usSLineSercosAddress;
} __TLR_PACKED_POST SIII_MA_CP_CHECK_RING_STATUS_CNF_DATA_T;

enum SIII_MA_CP_CHECK_RING_STATUS_Etag
{
  SIII_MA_CP_CHECK_RING_STATUS_NOT_A_RING                 = 0x0000,
  SIII_MA_CP_CHECK_RING_STATUS_IS_HEALABLE                = 0x0001,
  SIII_MA_CP_CHECK_RING_STATUS_IS_RING                    = 0x0002,
  SIII_MA_CP_CHECK_RING_STATUS_IS_RING_RESYNC_IN_PROGRESS = 0x0003,
  SIII_MA_CP_CHECK_RING_STATUS_HOT_PLUG_ACTIVE            = 0x0004
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CHECK_RING_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_CHECK_RING_STATUS_CNF_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_CHECK_RING_STATUS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CHECK_RING_STATUS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_CHECK_RING_STATUS_REQ_T        tReq;
  SIII_MA_CP_CHECK_RING_STATUS_CNF_T        tCnf;
} SIII_MA_CP_CHECK_RING_STATUS_PCK_T;


/**********************************************************************************************************************

   ####                                             #                               #                            ######  ##
  #    #                                                                   #                                      #    #  #
 #                                                                         #                                      #    #  #
 #        #####  ### #   ### #   ##  ##  ## ##    ###     #####   ####    ####    ###     #####  ## ##            #    #  # ##    ####    #####   #####
 #       #     #  # # #   # # #   #   #   ##  #     #    #     #      #    #        #    #     #  ##  #           #####   ##  #       #  #     # #     #
 #       #     #  # # #   # # #   #   #   #   #     #    #        #####    #        #    #     #  #   #           #       #   #   #####   ###    #######
 #       #     #  # # #   # # #   #   #   #   #     #    #       #    #    #        #    #     #  #   #           #       #   #  #    #      ##  #
  #    # #     #  # # #   # # #   #  ##   #   #     #    #     # #    #    #  #     #    #     #  #   #           #       #   #  #    #  #     # #     #
   ####   #####  ## # ## ## # ##   ## ## ### ###  #####   #####   #### #    ##    #####   #####  ### ###         ####    ### ###  #### #  #####   #####


*/

#define SIII_MA_CP_CMD_SET_PHASE_REQ                        0x00008900
#define SIII_MA_CP_CMD_SET_PHASE_CNF                        0x00008901

#define SIII_MA_CP_CMD_SET_PHASE_CP0_REQ                    0x00004800
#define SIII_MA_CP_CMD_SET_PHASE_CP0_CNF                    0x00004801

#define SIII_MA_CP_CMD_SET_PHASE_CP1_REQ                    0x00004802
#define SIII_MA_CP_CMD_SET_PHASE_CP1_CNF                    0x00004803

#define SIII_MA_CP_CMD_SET_PHASE_CP2_REQ                    0x00004804
#define SIII_MA_CP_CMD_SET_PHASE_CP2_CNF                    0x00004805

#define SIII_MA_CP_CMD_SET_PHASE_CP3_REQ                    0x00004806
#define SIII_MA_CP_CMD_SET_PHASE_CP3_CNF                    0x00004807

#define SIII_MA_CP_CMD_SET_PHASE_CP4_REQ                    0x00004808
#define SIII_MA_CP_CMD_SET_PHASE_CP4_CNF                    0x00004809

#define SIII_MA_CP_CMD_SET_PHASE_NRT_REQ                    0x0000480E
#define SIII_MA_CP_CMD_SET_PHASE_NRT_CNF                    0x0000480F

#define SIII_MA_CP_CMD_GET_DETECTED_SLAVE_LIST_CP0_REQ      0x00004810
#define SIII_MA_CP_CMD_GET_DETECTED_SLAVE_LIST_CP0_CNF      0x00004811

#define SIII_MA_CP_CMD_GET_DETECTED_SERCOS_ADDRESSES_REQ    0x00004812
#define SIII_MA_CP_CMD_GET_DETECTED_SERCOS_ADDRESSES_CNF    0x00004813

/* 0x00004814 ... 0x00004817 are reserved */

#define SIII_MA_CP_CMD_ALL_SLAVES_VALID_IN_CP0_IND          0x00004818
#define SIII_MA_CP_CMD_ALL_SLAVES_VALID_IN_CP0_RES          0x00004819

#define SIII_MA_CP_CMD_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_IND  0x0000481A
#define SIII_MA_CP_CMD_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_RES  0x0000481B

#define SIII_MA_CP_CMD_ALL_SLAVES_IN_TWO_LINES_IND          0x0000481C
#define SIII_MA_CP_CMD_ALL_SLAVES_IN_TWO_LINES_RES          0x0000481D

#define SIII_MA_CP_CMD_UNCONFIGURED_SLAVE_DETECTED_IND      0x000048C0
#define SIII_MA_CP_CMD_UNCONFIGURED_SLAVE_DETECTED_RES      0x000048C1

#define SIII_MA_CP_CMD_DUPLICATE_SERCOS_ADDRESS_IND         0x000048C2
#define SIII_MA_CP_CMD_DUPLICATE_SERCOS_ADDRESS_RES         0x000048C3

#define SIII_MA_CP_CMD_INVALID_SERCOS_ADDRESS_DETECTED_IND  0x0000486A
#define SIII_MA_CP_CMD_INVALID_SERCOS_ADDRESS_DETECTED_RES  0x0000586B

#define SIII_MA_CP_CMD_NO_BUS_CONNECTED_IND                 0x0000481E
#define SIII_MA_CP_CMD_NO_BUS_CONNECTED_RES                 0x0000481F

#define SIII_MA_CP_CMD_INCORRECT_CP0_TOPO_INFO_IND          0x00008926
#define SIII_MA_CP_CMD_INCORRECT_CP0_TOPO_INFO_RES          0x00008927

#define SIII_MA_CP_CMD_FEATURES_NOT_ACKNOWLEDGED_IND        0x00008928
#define SIII_MA_CP_CMD_FEATURES_NOT_ACKNOWLEDGED_RES        0x00008929

#define SIII_MA_CP_CMD_NO_MATCHING_MANDATORY_SLAVE_LIST_IND 0x00008930
#define SIII_MA_CP_CMD_NO_MATCHING_MANDATORY_SLAVE_LIST_RES 0x00008931

#define SIII_MA_CP_CMD_HARD_STOP_TO_NRT_PHASE_REQ           0x0000893A
#define SIII_MA_CP_CMD_HARD_STOP_TO_NRT_PHASE_CNF           0x0000893B

#define SIII_MA_CP_CMD_WAITING_FOR_SLAVES_IND               0x00008946
#define SIII_MA_CP_CMD_WAITING_FOR_SLAVES_RES               0x00008947

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_NO_MATCHING_MANDATORY_SLAVE_LIST_IND/SIII_MA_CP_CMD_NO_MATCHING_MANDATORY_SLAVE_LIST_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_RES_T;


/* packet union */
typedef union SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_IND_T tInd;
  SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_RES_T tRes;
} SIII_MA_CP_NO_MATCHING_MANDATORY_SLAVE_LIST_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_WAITING_FOR_SLAVES_IND/SIII_MA_CP_CMD_WAITING_FOR_SLAVES_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_WAITING_FOR_SLAVES_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_WAITING_FOR_SLAVES_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_WAITING_FOR_SLAVES_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_WAITING_FOR_SLAVES_RES_T;


/* packet union */
typedef union SIII_MA_CP_WAITING_FOR_SLAVES_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_WAITING_FOR_SLAVES_IND_T               tInd;
  SIII_MA_CP_WAITING_FOR_SLAVES_RES_T               tRes;
} SIII_MA_CP_WAITING_FOR_SLAVES_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_FEATURES_NOT_ACKNOWLEDGED_IND/SIII_MA_CP_CMD_FEATURES_NOT_ACKNOWLEDGED_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_RES_T;


/* packet union */
typedef union SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_IND_T        tInd;
  SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_RES_T        tRes;
} SIII_MA_CP_FEATURES_NOT_ACKNOWLEDGED_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_INCORRECT_CP0_TOPO_INFO_IND/SIII_MA_CP_CMD_INCORRECT_CP0_TOPO_INFO_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_RES_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_RES_T;


/* packet union */
typedef union SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_IND_T  tInd;
  SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_RES_T  tRes;
} SIII_MA_CP_INCORRECT_CP0_TOPO_INFO_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ALL_SLAVES_VALID_IN_CP0_IND/SIII_MA_CP_CMD_ALL_SLAVES_VALID_IN_CP0_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_RES_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_RES_T;


/* packet union */
typedef union SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_IND_T  tInd;
  SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_RES_T  tRes;
} SIII_MA_CP_ALL_SLAVES_VALID_IN_CP0_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_DUPLICATE_SERCOS_ADDRESS_IND/SIII_MA_CP_CMD_DUPLICATE_SERCOS_ADDRESS_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_RES_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_RES_T;


/* packet union */
typedef union SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_IND_T tInd;
  SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_RES_T tRes;
} SIII_MA_CP_DUPLICATE_SERCOS_ADDRESS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_INVALID_SERCOS_ADDRESS_DETECTED_IND/SIII_MA_CP_CMD_INVALID_SERCOS_ADDRESS_DETECTED_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_RES_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_RES_T;


/* packet union */
typedef union SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_IND_T  tInd;
  SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_RES_T  tRes;
} SIII_MA_CP_INVALID_SERCOS_ADDRESS_DETECTED_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_UNCONFIGURED_SLAVE_DETECTED_IND/SIII_MA_CP_CMD_UNCONFIGURED_SLAVE_DETECTED_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_RES_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_RES_T;


/* packet union */
typedef union SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_IND_T  tInd;
  SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_RES_T  tRes;
} SIII_MA_CP_UNCONFIGURED_SLAVE_DETECTED_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_IND/SIII_MA_CP_CMD_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_RES
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_IND_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_IND_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_RES_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_RES_T;


/* packet union */
typedef union SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_IND_T  tInd;
  SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_RES_T  tRes;
} SIII_MA_CP_AT_LEAST_ONE_SLAVE_MISSING_IN_CP0_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_REQ/SIII_MA_CP_CMD_SET_PHASE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_REQ_DATA_Ttag
{
  TLR_UINT8                                         bTargetPhase;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_SET_PHASE_REQ_DATA_T                   tData;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CNF_DATA_Ttag
{
  TLR_UINT8                                         bTargetPhase;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_SET_PHASE_CNF_DATA_T                   tData;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_PCK_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  SIII_MA_CP_SET_PHASE_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_CP0_REQ/SIII_MA_CP_CMD_SET_PHASE_CP0_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP0_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP0_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP0_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP0_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_CP0_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_SET_PHASE_CP0_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_CP0_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_CP0_PCK_T;

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_CP1_REQ/SIII_MA_CP_CMD_SET_PHASE_CP1_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP1_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP1_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP1_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP1_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_CP1_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_SET_PHASE_CP1_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_CP1_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_CP1_PCK_T;

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_CP2_REQ/SIII_MA_CP_CMD_SET_PHASE_CP2_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP2_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP2_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP2_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP2_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_CP2_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_SET_PHASE_CP2_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_CP2_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_CP2_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_CP3_REQ/SIII_MA_CP_CMD_SET_PHASE_CP3_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP3_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP3_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP3_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP3_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_CP3_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_SET_PHASE_CP3_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_CP3_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_CP3_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_CP4_REQ/SIII_MA_CP_CMD_SET_PHASE_CP4_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP4_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP4_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_CP4_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_CP4_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_CP4_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_SET_PHASE_CP4_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_CP4_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_CP4_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_PHASE_NRT_REQ/SIII_MA_CP_CMD_SET_PHASE_NRT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_NRT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_NRT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_PHASE_NRT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_PHASE_NRT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_PHASE_NRT_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_SET_PHASE_NRT_REQ_T  tReq;
  SIII_MA_CP_SET_PHASE_NRT_CNF_T  tCnf;
} SIII_MA_CP_SET_PHASE_NRT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_HARD_STOP_TO_NRT_PHASE_REQ/SIII_MA_CP_CMD_HARD_STOP_TO_NRT_PHASE_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_REQ_T   tReq;
  SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_CNF_T   tCnf;
} SIII_MA_CP_HARD_STOP_TO_NRT_PHASE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_DETECTED_SLAVE_LIST_CP0_REQ/SIII_MA_CP_CMD_GET_DETECTED_SLAVE_LIST_CP0_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DETECTED_SLAVE_LIST_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_CNF_DATA_Ttag
{
  TLR_UINT8                                       abSlaveBitList[512 >> 3];
} __TLR_PACKED_POST SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_CNF_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_REQ_T    tReq;
  SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_CNF_T    tCnf;
} SIII_MA_CP_GET_DETECTED_SLAVE_LIST_CP0_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_DETECTED_SERCOS_ADDRESSES_REQ/SIII_MA_CP_CMD_GET_DETECTED_SERCOS_ADDRESSES_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_REQ_T;


/* confirmation packet, UP TO 512 entries. Cnf packet len is number of found slaves * sizeof(UINT16) */
#define SIII_MA_CP_NUM_TOPOLOGY_ADDRESSES       512

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_CNF_DATA_Ttag
{
  TLR_UINT16                                      ausSercosAddresses[SIII_MA_CP_NUM_TOPOLOGY_ADDRESSES];
} __TLR_PACKED_POST SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_CNF_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_REQ_T  tReq;
  SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_CNF_T  tCnf;
} SIII_MA_CP_GET_DETECTED_SERCOS_ADDRESSES_PCK_T;


/**********************************************************************************************************************

   ####                     ##      #                                               #                            ######                  ##                               #####
  #    #                   #                                               #                                      #    #                  #                #                #              #
 #                         #                                               #                                      #    #                  #                #                #              #
 #        #####  ## ##    ####    ###     ###### ##  ##  ### ##   ####    ####    ###     #####  ## ##            #    #  ####    #####   #  ##   #####   ####              #    ## ##    ####    #####
 #       #     #  ##  #    #        #    #    #   #   #    ##  #      #    #        #    #     #  ##  #           #####       #  #     #  #  #   #     #   #                #     ##  #    #     #     #
 #       #     #  #   #    #        #    #    #   #   #    #      #####    #        #    #     #  #   #           #       #####  #        # #    #######   #                #     #   #    #     #######
 #       #     #  #   #    #        #    #    #   #   #    #     #    #    #        #    #     #  #   #           #      #    #  #        ###    #         #                #     #   #    #     #
  #    # #     #  #   #    #        #     #####   #  ##    #     #    #    #  #     #    #     #  #   #           #      #    #  #     #  #  #   #     #   #  #             #     #   #    #  #  #     #
   ####   #####  ### ###  ####    #####       #    ## ## #####    #### #    ##    #####   #####  ### ###         ####     #### #  #####  ##   ##  #####     ##            #####  ### ###    ##    #####
                                              #
                                          ####
*/

/*
 * On start of a configuration data transfer, the master has to be in CP0.
 * If a configuration data transfer is in progress, the master is kept in CP0.
 *
 * Following flow is defined for configuration data transfer:
 *
 * 1. SIII_MA_CP_CMD_BEGIN_CONFIGURATION_REQ
 *    Begin configuration data transfer
 *
 * 2. SIII_MA_CP_CMD_ADD_SLAVE_REQ
 *
 * 2a. SIII_MA_CP_CMD_ADD_CONNECTION_REQ for all connections
 *
 * 2b. SIII_MA_CP_CMD_ADD_INITCMD_REQ for all writes and compares required for setting up the slave
 *
 * 3. Iterate over 2., 2a. and 2b. for all slaves
 *
 * 4. SIII_MA_CP_CMD_END_CONFIGURATION_REQ
 *    End configuration data transfer
 */

/* Begin a new configuration transfer, setup system global parameters */
#define SIII_MA_CP_CMD_BEGIN_CONFIGURATION_REQ              0x00004820
#define SIII_MA_CP_CMD_BEGIN_CONFIGURATION_CNF              0x00004821

/* Open a configuration for editing (no AutoCFG handling on a reopen config) */
#define SIII_MA_CP_CMD_REOPEN_CONFIGURATION_REQ             0x00008950
#define SIII_MA_CP_CMD_REOPEN_CONFIGURATION_CNF             0x00008951

/* End a configuration transfer. make new config valid */
#define SIII_MA_CP_CMD_END_CONFIGURATION_REQ                0x00004822
#define SIII_MA_CP_CMD_END_CONFIGURATION_CNF                0x00004823

/* Abort a configuration transfer */
#define SIII_MA_CP_CMD_ABORT_CONFIGURATION_REQ              0x00004824
#define SIII_MA_CP_CMD_ABORT_CONFIGURATION_CNF              0x00004825

/* Add Slave Data block */
#define SIII_MA_CP_CMD_ADD_SLAVE_REQ                        0x00004826
#define SIII_MA_CP_CMD_ADD_SLAVE_CNF                        0x00004827

/* Add Connection Data block */
#define SIII_MA_CP_CMD_ADD_CONNECTION_REQ                   0x00004828
#define SIII_MA_CP_CMD_ADD_CONNECTION_CNF                   0x00004829

/* Add InitCmd */
#define SIII_MA_CP_CMD_ADD_INITCMD_REQ                      0x0000482A
#define SIII_MA_CP_CMD_ADD_INITCMD_CNF                      0x0000482B

#define SIII_MA_CP_CMD_ADD_INITCMD_EXT_REQ                  0x0000895A
#define SIII_MA_CP_CMD_ADD_INITCMD_EXT_CNF                  0x0000895B

#define SIII_MA_CP_CMD_INSERT_INITCMD_REQ                   0x00008956
#define SIII_MA_CP_CMD_INSERT_INITCMD_CNF                   0x00008957

#define SIII_MA_CP_CMD_REPLACE_INITCMD_REQ                  0x00008958
#define SIII_MA_CP_CMD_REPLACE_INITCMD_CNF                  0x00008959

/* Configure Master */
#define SIII_MA_CP_CMD_CONFIGURE_MASTER_REQ                 0x0000482C
#define SIII_MA_CP_CMD_CONFIGURE_MASTER_CNF                 0x0000482D

/* Configure Frame sizes (can only be used to make frames bigger) */
#define SIII_MA_CP_CMD_CONFIGURE_FRAME_SIZES_REQ            0x0000482E
#define SIII_MA_CP_CMD_CONFIGURE_FRAME_SIZES_CNF            0x0000482F

/* Unload configuration */
#define SIII_MA_CP_CMD_UNLOAD_CONFIGURATION_REQ             0x00004870
#define SIII_MA_CP_CMD_UNLOAD_CONFIGURATION_CNF             0x00004871

/* Get Connection information */
#define SIII_MA_CP_CMD_GET_CONNECTION_INFO_REQ              0x00004872
#define SIII_MA_CP_CMD_GET_CONNECTION_INFO_CNF              0x00004873

/* Get configured slaves */
#define SIII_MA_CP_CMD_GET_CONFIGURED_SLAVES_REQ            0x00008906
#define SIII_MA_CP_CMD_GET_CONFIGURED_SLAVES_CNF            0x00008907

/* Get configured connections of slave */
#define SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ  0x00008908
#define SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF  0x00008909

/* Get Timing Configuration information in CP3/CP4 */
#define SIII_MA_CP_CMD_GET_TIMING_CONFIG_REQ                0x00004874
#define SIII_MA_CP_CMD_GET_TIMING_CONFIG_CNF                0x00004875

/* Add Slave Data Block for an SCP_FixCfg slave */
#define SIII_MA_CP_CMD_ADD_FIXCFG_SLAVE_REQ                 0x00004876
#define SIII_MA_CP_CMD_ADD_FIXCFG_SLAVE_CNF                 0x00004877

/* Add Slave Data Block for an SCP_FixCfg slave */
#define SIII_MA_CP_CMD_ADD_VARCFG_SLAVE_REQ                 0x00004878
#define SIII_MA_CP_CMD_ADD_VARCFG_SLAVE_CNF                 0x00004879

/* AutoCfg variant of packet configuration */
#define SIII_MA_CP_CMD_AUTOCFG_ADD_FIXCFG_SLAVE_REQ         0x0000487A
#define SIII_MA_CP_CMD_AUTOCFG_ADD_FIXCFG_SLAVE_CNF         0x0000487B

#define SIII_MA_CP_CMD_AUTOCFG_ADD_VARCFG_SLAVE_REQ         0x0000487C
#define SIII_MA_CP_CMD_AUTOCFG_ADD_VARCFG_SLAVE_CNF         0x0000487D

#define SIII_MA_CP_CMD_AUTOCFG_ADD_CONNECTION_REQ           0x0000487E
#define SIII_MA_CP_CMD_AUTOCFG_ADD_CONNECTION_CNF           0x0000487F

#define SIII_MA_CP_CMD_ADD_SLAVE_IDENT_REQ                  0x00008910
#define SIII_MA_CP_CMD_ADD_SLAVE_IDENT_CNF                  0x00008911

#define SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_IDENT_REQ       0x00008912
#define SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_IDENT_CNF       0x00008913

#define SIII_MA_CP_CMD_ADD_CONNECTION_LAYOUT_REQ            0x00008914
#define SIII_MA_CP_CMD_ADD_CONNECTION_LAYOUT_CNF            0x00008915

#define SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTION_LAYOUT_REQ 0x00008916
#define SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTION_LAYOUT_CNF 0x00008917


#define SIII_MA_CP_CMD_GET_MINIMUM_TIMING_WINDOWS_REQ       0x00008918
#define SIII_MA_CP_CMD_GET_MINIMUM_TIMING_WINDOWS_CNF       0x00008919

#define SIII_MA_CP_CMD_CHANGE_CP3_CP4_TIMING_REQ            0x0000891A
#define SIII_MA_CP_CMD_CHANGE_CP3_CP4_TIMING_CNF            0x0000891B

#define SIII_MA_CP_CMD_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ   0x0000892C
#define SIII_MA_CP_CMD_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_CNF   0x0000892D

#define SIII_MA_CP_CMD_ADD_MANDATORY_SLAVE_LIST_REQ         0x0000892E
#define SIII_MA_CP_CMD_ADD_MANDATORY_SLAVE_LIST_CNF         0x0000892F

#define SIII_MA_CP_CMD_ADD_SCP_NRT_CFG_REQ                  0x00008932
#define SIII_MA_CP_CMD_ADD_SCP_NRT_CFG_CNF                  0x00008933

#define SIII_MA_CP_CMD_GET_CONNECTION_SETUP_REQ             0x00008934
#define SIII_MA_CP_CMD_GET_CONNECTION_SETUP_CNF             0x00008935

#define SIII_MA_CP_CMD_MODIFY_CONNECTION_SETUP_REQ          0x00008936
#define SIII_MA_CP_CMD_MODIFY_CONNECTION_SETUP_CNF          0x00008937

#define SIII_MA_CP_CMD_GET_SCP_NRT_CFG_REQ                  0x00008942
#define SIII_MA_CP_CMD_GET_SCP_NRT_CFG_CNF                  0x00008943

#define SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_INFO_REQ        0x00008944
#define SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_INFO_CNF        0x00008945

/* SIII_MA_CP_CMD_AUTOCFG_ADD_TIMING_LIMITS_REQ only needed for Auto-Calculation of timing */
#define SIII_MA_CP_CMD_AUTOCFG_ADD_TIMING_LIMITS_REQ        0x0000894A
#define SIII_MA_CP_CMD_AUTOCFG_ADD_TIMING_LIMITS_CNF        0x0000894B

#define SIII_MA_CP_CMD_CONFIGURE_SLAVE_DEVICE_RELATION_REQ  0x0000894C
#define SIII_MA_CP_CMD_CONFIGURE_SLAVE_DEVICE_RELATION_CNF  0x0000894D

#define SIII_MA_CP_CMD_GET_SLAVE_DEVICE_RELATION_REQ        0x0000894E
#define SIII_MA_CP_CMD_GET_SLAVE_DEVICE_RELATION_CNF        0x0000894F

#define SIII_MA_CP_CMD_GET_INITCMD_COUNT_REQ                0x00008952
#define SIII_MA_CP_CMD_GET_INITCMD_COUNT_CNF                0x00008953

#define SIII_MA_CP_CMD_GET_INITCMD_INFO_REQ                 0x00008954
#define SIII_MA_CP_CMD_GET_INITCMD_INFO_CNF                 0x00008955

#define SIII_MA_CP_CMD_MODIFY_CONFIG_PARAMS_REQ             0x00008962
#define SIII_MA_CP_CMD_MODIFY_CONFIG_PARAMS_CNF             0x00008963

/**************************************
 * Constants
 */

/****************************/
/* usFunctionType */
enum SIII_MA_CP_CONNECTION_FUNCTION_TYPE_Etag
{
  SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_MASTER            = 0x0000,
  SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_CC                = 0x0001,
  SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_SCP_SYSTIME_CTRL  = 0x0002, /* must be used with master address 65535, instance = don't care */
  SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_SCP_SYSTIME_STAT  = 0x0003, /* must be used with master address 65535, instance = don't care */

  /* following constants only for SIII_MA_CP_CMD_AUTOCFG_ADD_CONNECTION_REQ */
  SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_MASTER_MDT        = 0x8000,
  SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_MASTER_AT         = 0x0000
};

/****************************/
/* SCP classes */
enum
{
  SIII_MA_CP_SCP_FixCFG             = 0x0101, /* V1.1.1 (internally handled) */
  SIII_MA_CP_SCP_FixCFG_0x02        = 0x0102, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_FixCFG_0x03        = 0x0103, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_VarCFG             = 0x0201, /* V1.1.1 (internally handled) */
  SIII_MA_CP_SCP_VarCFG_0x02        = 0x0202, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_VarCFG_0x03        = 0x0203, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_Sync               = 0x0301, /* V1.1.1 (internally handled) */
  SIII_MA_CP_SCP_Sync_0x02          = 0x0302, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_Sync_0x03          = 0x0303, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_WD                 = 0x0401, /* V1.1.1 (replaced by SCP_WDCon) */
  SIII_MA_CP_SCP_Diag               = 0x0501, /* V1.1.1 */
  SIII_MA_CP_SCP_RTB                = 0x0601, /* V1.1.1 */
  SIII_MA_CP_SCP_HP                 = 0x0701, /* V1.1.1 (internally handled) */
  SIII_MA_CP_SCP_SMP                = 0x0801, /* V1.1.1 */
  SIII_MA_CP_SCP_MuX                = 0x0901, /* V1.1.1 */
  SIII_MA_CP_SCP_NRT                = 0x0A01, /* V1.1.1 (replaced by SCP_NRTPC, internally handled) */
  SIII_MA_CP_SCP_SIG                = 0x0B01, /* V1.1.1 */
  SIII_MA_CP_SCP_ListSeg            = 0x0C01, /* V1.3 */
  SIII_MA_CP_SCP_SIP                = 0x0D01, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_TFTP               = 0x0E01, /* V1.3 */
  SIII_MA_CP_SCP_Cap                = 0x0F01, /* V1.3 */
  SIII_MA_CP_SCP_ExtMuX             = 0x1001, /* V1.1.2 */
  SIII_MA_CP_SCP_RTBListProd        = 0x1101, /* V1.3 */
  SIII_MA_CP_SCP_RTBListCons        = 0x1201, /* V1.3 */
  SIII_MA_CP_SCP_SysTime            = 0x1301, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_RTBWordProd        = 0x1401, /* V1.3 */
  SIII_MA_CP_SCP_RTBWordCons        = 0x1501, /* V1.3 */
  SIII_MA_CP_SCP_SafetyCon          = 0x1601, /* V1.3 */
  SIII_MA_CP_SCP_OvSBasic           = 0x1701, /* V1.3 */
  SIII_MA_CP_SCP_NRTPC              = 0x1801, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_Cyc                = 0x1901, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_WDCon              = 0x1A01, /* V1.3 (internally handled) */
  SIII_MA_CP_SCP_SWC                = 0x1B01, /* V1.3.1 (internally handled) */
};

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_MANDATORY_SLAVE_LIST_REQ/SIII_MA_CP_CMD_ADD_MANDATORY_SLAVE_LIST_CNF
 *
 *          Allow multiple mandatory slave list variant
 *          Any list that matches will allow the master to boot up
 *
 *          No list added means that all slaves that are not optional are mandatory.
 *
 *          Slaves that are not contained in all mandatory slave lists must be set to optional in AddSlave requests
 *
 *          Remarks: This packet must be used after all ADD_SLAVE requests have been processed.
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_DATA_Ttag
{
  TLR_UINT16 ausSercosAddresses[511];
} __TLR_PACKED_POST SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_DATA_T;

#define SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_MIN_SIZE 0

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_CNF_DATA_Ttag
{
  TLR_UINT16 usErrorIdx; /* 0xFFFF if invalid */
} __TLR_PACKED_POST SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_CNF_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_REQ_T             tReq;
  SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_CNF_T             tCnf;
} SIII_MA_CP_ADD_MANDATORY_SLAVE_LIST_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CONFIGURE_SLAVE_DEVICE_RELATION_REQ/SIII_MA_CP_CMD_CONFIGURE_SLAVE_DEVICE_RELATION_CNF
 *
 * single slave device do not need to be configured by this request
 * However, it is allowed and allows simplification of the application code
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_REQ_DATA_Ttag
{
  /* list of groups, a new group begins when Bit 15 is set */
  TLR_UINT16  ausGroupDefinitions[511]; /* actual length is determined by tHead.ulLen */
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_REQ_DATA_T;

#define MSK_SIII_MA_CP_GROUP_DEF_BEGIN  0x8000

#define SIII_MA_CP_GROUP_DEF_BEGIN(usSlaveAddress) (MSK_SIII_MA_CP_GROUP_DEF_BEGIN | (usSlaveAddress))
#define SIII_MA_CP_GROUP_DEF_MEMBER(usSlaveAddress) (usSlaveAddress)

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_REQ_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_REQ_T      tReq;
  SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_CNF_T      tCnf;
} SIII_MA_CP_CONFIGURE_SLAVE_DEVICE_RELATION_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_SLAVE_DEVICE_RELATION_REQ/SIII_MA_CP_CMD_GET_SLAVE_DEVICE_RELATION_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_CNF_DATA_Ttag
{
  /* list of groups, a new group begins when Bit 15 is set */
  TLR_UINT16  ausGroupDefinitions[511]; /* actual length is determined by tHead.ulLen */
  /* same definition as in SIII_MA_CP_CMD_CONFIGURE_SLAVE_DEVICE_RELATION_REQ */
} __TLR_PACKED_POST SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_CNF_DATA_T;

#define SIII_MA_CP_GROUP_DEF_GET_ADDRESS(usGroupDef) ((usGroupDef) & 0x7FFF)

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_CNF_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_REQ_T      tReq;
  SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_CNF_T      tCnf;
} SIII_MA_CP_GET_SLAVE_DEVICE_RELATION_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_SCP_NRT_CFG_REQ/SIII_MA_CP_CMD_ADD_SCP_NRT_CFG_CNF
 *
 *          add SCP_NRT configuration
 *
 *          multiple contradictory configurations for a multi-slave device will be denied on boot up
 *
 *          same request will be used for master with ausSercosAddresses[0] = 65535 and no further entries
 *
 *          ausSercosAddresses[0] will be used for configuring SCP_NRT/SCP_NRTPC
 *          ausSercosAddresses[index] must match S-0-1046[index]
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_DATA_Ttag
{
  TLR_UINT8                                     abIPAddress[4];
  TLR_UINT8                                     abSubnetMask[4];
  TLR_UINT8                                     abGateway[4];
  TLR_UINT8                                     bHostnameLength;
  TLR_UINT8                                     abHostname[255];
  TLR_UINT16                                    ausSercosAddresses[16]; /* variable number of slave addresses depending on multi-slave device
                                                                         (can be up to 16, actual number depends on packet length) */
} __TLR_PACKED_POST SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_T;

#define SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_MIN_SIZE         (67 * sizeof(TLR_UINT32))

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SCP_NRT_CFG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SCP_NRT_CFG_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_SCP_NRT_CFG_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_ADD_SCP_NRT_CFG_REQ_T                tReq;
  SIII_MA_CP_ADD_SCP_NRT_CFG_CNF_T                tCnf;
} SIII_MA_CP_ADD_SCP_NRT_CFG_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_SCP_NRT_CFG_REQ/SIII_MA_CP_CMD_GET_SCP_NRT_CFG_CNF
 *
 *          Get optionally configured SCP_NRT/SCP_NRTPC configuration
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SCP_NRT_CFG_REQ_DATA_Ttag
{
  TLR_UINT16                                      usSercosAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_SCP_NRT_CFG_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SCP_NRT_CFG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_SCP_NRT_CFG_REQ_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_SCP_NRT_CFG_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SCP_NRT_CFG_CNF_DATA_Ttag
{
  TLR_UINT16                                      usSlaveAddress;
  TLR_UINT16                                      usSlaveIndex;
  TLR_UINT8                                       abIPAddress[4];
  TLR_UINT8                                       abSubnetMask[4];
  TLR_UINT8                                       abGateway[4];
  TLR_UINT8                                       bHostnameLength;
  TLR_UINT8                                       abHostname[255];
} __TLR_PACKED_POST SIII_MA_CP_GET_SCP_NRT_CFG_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_SCP_NRT_CFG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_SCP_NRT_CFG_CNF_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_SCP_NRT_CFG_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_SCP_NRT_CFG_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_SCP_NRT_CFG_REQ_T                tReq;
  SIII_MA_CP_GET_SCP_NRT_CFG_CNF_T                tCnf;
} SIII_MA_CP_GET_SCP_NRT_CFG_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CHANGE_CP3_CP4_TIMING_REQ/SIII_MA_CP_CMD_CHANGE_CP3_CP4_TIMING_CNF
 *
 *          Get minimum required timing windows
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CHANGE_CP3_CP4_TIMING_REQ_DATA_Ttag
{
  /* S-0-1002 Communication Cycle Time (CP3/4) in ns */
  TLR_UINT32                                    ulCommunicationCycleTime;
  /* S-0-1006 AT Transmission Starting Time in ns*/
  TLR_UINT32                                    ulATTransmissionStartingTime;
  /* S-0-1017 NRT transmission time (t6 & t7) in ns */
  TLR_UINT32                                    ulTransmissionTime_t6;
  TLR_UINT32                                    ulTransmissionTime_t7;
  /* S-0-1007 Feedback acquisition capture point (t4) in ns */
  TLR_UINT32                                    ulSynchronizationTime;
  /* S-0-1027.0.1 NRT channel MTU */
  TLR_UINT16                                    usNRTChannelMTU;
  TLR_UINT32                                    ulModeFlags;
  TLR_UINT32                                    aulReserved[15];
} __TLR_PACKED_POST SIII_MA_CP_CHANGE_CP3_CP4_TIMING_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CHANGE_CP3_CP4_TIMING_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_CHANGE_CP3_CP4_TIMING_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_CHANGE_CP3_CP4_TIMING_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CHANGE_CP3_CP4_TIMING_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_CHANGE_CP3_CP4_TIMING_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CHANGE_CP3_CP4_TIMING_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_CHANGE_CP3_CP4_TIMING_REQ_T        tReq;
  SIII_MA_CP_CHANGE_CP3_CP4_TIMING_CNF_T        tCnf;
} SIII_MA_CP_CHANGE_CP3_CP4_TIMING_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_MINIMUM_TIMING_WINDOWS_REQ/SIII_MA_CP_CMD_GET_MINIMUM_TIMING_WINDOWS_CNF
 *
 *          Get minimum required timing windows
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_REQ_DATA_Ttag
{
  TLR_UINT16                                        usRequestedMtu;   /* 0 => off, other parameters are used for calculating the required NRT Window Time */
} __TLR_PACKED_POST SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_CNF_DATA_Ttag
{
  TLR_UINT32                                        ulMDTWindowTimeNs;
  TLR_UINT32                                        ulATWindowTimeNs;
  TLR_UINT32                                        ulNRTWindowTimeNs;
  TLR_UINT32                                        ulTotalIfgJitterNs;
  TLR_UINT32                                        ulIfgJitterNs;
  TLR_UINT32                                        ulMarginToUsableCommCycleTimeNs;
  TLR_UINT32                                        ulMdtCount;
  TLR_UINT32                                        ulAtCount;
} __TLR_PACKED_POST SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_CNF_T;


/* packet union */
typedef union SIIIMA_CP_GET_MINIMUM_TIMING_WINDOWS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_REQ_T       tReq;
  SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_CNF_T       tCnf;
} SIII_MA_CP_GET_MINIMUM_TIMING_WINDOWS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CONNECTION_SETUP_REQ/SIII_MA_CP_CMD_GET_CONNECTION_SETUP_CNF
 *
 *          Get configured slaves when master is configured
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_SETUP_REQ_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT8                                         bConnectionInstance;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_SETUP_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_SETUP_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_CONNECTION_SETUP_REQ_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_SETUP_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_SETUP_CNF_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT8                                         bConnectionInstance;
  TLR_UINT8                                         bReserved;
  TLR_UINT16                                        usConnectionSetup;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_SETUP_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_SETUP_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_CONNECTION_SETUP_CNF_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_SETUP_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_CONNECTION_SETUP_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_CONNECTION_SETUP_REQ_T             tReq;
  SIII_MA_CP_GET_CONNECTION_SETUP_CNF_T             tCnf;
} SIII_MA_CP_GET_CONNECTION_SETUP_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_MODIFY_CONNECTION_SETUP_REQ/SIII_MA_CP_CMD_MODIFY_CONNECTION_SETUP_CNF
 *
 *          Get configured slaves when master is configured
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONNECTION_SETUP_REQ_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT8                                         bConnectionInstance;
  TLR_UINT8                                         bReserved;
  TLR_UINT16                                        usConnectionSetup;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONNECTION_SETUP_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONNECTION_SETUP_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_MODIFY_CONNECTION_SETUP_REQ_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONNECTION_SETUP_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONNECTION_SETUP_CNF_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT8                                         bConnectionInstance;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONNECTION_SETUP_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONNECTION_SETUP_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_MODIFY_CONNECTION_SETUP_CNF_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONNECTION_SETUP_CNF_T;


/* packet union */
typedef union SIII_MA_CP_MODIFY_CONNECTION_SETUP_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_MODIFY_CONNECTION_SETUP_REQ_T          tReq;
  SIII_MA_CP_MODIFY_CONNECTION_SETUP_CNF_T          tCnf;
} SIII_MA_CP_MODIFY_CONNECTION_SETUP_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CONFIGURED_SLAVES_REQ/SIII_MA_CP_CMD_GET_CONFIGURED_SLAVES_CNF
 *
 *          Get configured slaves when master is configured
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVES_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVES_REQ_T;


/* confirmation packet */
#define SIII_MA_CP_MAX_CONFIGURED_SLAVES 511

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVES_CNF_DATA_Ttag
{
  TLR_UINT16                                    ausConfiguredSercosAddresses[SIII_MA_CP_MAX_CONFIGURED_SLAVES];
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVES_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVES_CNF_T
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVES_CNF_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVES_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_CONFIGURED_SLAVES_PCK_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVES_REQ_T  tReq;
  SIII_MA_CP_GET_CONFIGURED_SLAVES_CNF_T  tCnf;
} SIII_MA_CP_GET_CONFIGURED_SLAVES_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ/SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF
 *
 *          Get configured connections of configured sercos address when master is configured
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ_DATA_Ttag
{
  TLR_UINT16                                                usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                       tHead;
  SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_DATA_Ttag
{
  TLR_UINT16                                                usSlaveAddress;
  TLR_UINT8                                                 abConfiguredConnInstances[256];
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                       tHead;
  SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_T;

#define SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_EMPTY_SIZE (sizeof(TLR_UINT16))


/* packet union */
typedef union SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                   tHead;
  SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_REQ_T  tReq;
  SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_CNF_T  tCnf;
} SIII_MA_CP_GET_CONFIGURED_CONNECTIONS_OF_SLAVE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ/SIII_MA_CP_CMD_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_CNF
 *
 *          Add a slave specific active SCP classes list to configuration
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_DATA_Ttag
{
  TLR_UINT16        usSlaveAddress;
  TLR_UINT16        ausSCPClass[256];   /* internally handled SCP classes cannot be specified here, only one SCP class allowed here */
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_DATA_T;

#define SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_MIN_SIZE (1 * sizeof(TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                       tHead;
  SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_REQ_T     tReq;
  SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_CNF_T     tCnf;
} SIII_MA_CP_CONFIGURE_SLAVE_ACTIVE_SCP_CLASSES_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_SLAVE_IDENT_REQ/SIII_MA_CP_CMD_ADD_SLAVE_IDENT_CNF
 *
 *          Add a slave identification to configuration
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SLAVE_IDENT_REQ_DATA_Ttag
{
  TLR_UINT16        usSlaveAddress;
  TLR_UINT16        usConfigFlags;   /* reserved set to 0 */
  TLR_UINT16        usVendorCode;
  TLR_UINT8         abDeviceID[255];  /* actual length depends on tHead.ulLen (possible size 1 -> 255) */
} __TLR_PACKED_POST SIII_MA_CP_ADD_SLAVE_IDENT_REQ_DATA_T;

#define SIII_MA_CP_ADD_SLAVE_IDENT_REQ_MIN_SIZE (3 * sizeof(TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SLAVE_IDENT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_CP_ADD_SLAVE_IDENT_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SLAVE_IDENT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SLAVE_IDENT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SLAVE_IDENT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_SLAVE_IDENT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
  SIII_MA_CP_ADD_SLAVE_IDENT_REQ_T        tReq;
  SIII_MA_CP_ADD_SLAVE_IDENT_CNF_T        tCnf;
} SIII_MA_CP_ADD_SLAVE_IDENT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_IDENT_REQ/SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_IDENT_CNF
 *
 *          Get a slave identification from configuration
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_REQ_DATA_Ttag
{
  TLR_UINT16                              usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_DATA_Ttag
{
  TLR_UINT16        usConfigFlags;
  TLR_UINT16        usVendorCode;
  TLR_UINT8         abDeviceID[255];
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_DATA_T;

#define SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_MIN_SIZE (2 * sizeof(TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_T;

/* packet union */
typedef union SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_REQ_T       tReq;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_CNF_T       tCnf;
} SIII_MA_CP_GET_CONFIGURED_SLAVE_IDENT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_CONNECTION_LAYOUT_REQ/SIII_MA_CP_CMD_ADD_CONNECTION_LAYOUT_CNF
 *
 *          Add connection layout configuration
 */

/* common structures */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONNECTION_LAYOUT_ENTRY_DATA_Ttag
{
  TLR_UINT32                                      ulIDN;
  TLR_UINT16                                      usDataLength;
  TLR_UINT16                                      usConfigFlags;
} __TLR_PACKED_POST SIII_MA_CP_CONNECTION_LAYOUT_ENTRY_DATA_T;

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_DATA_Ttag
{
  TLR_UINT16                                      usSlaveAddress;
  TLR_UINT8                                       bConnectionInstance;
  TLR_UINT16                                      usNumberOfEntries;
  SIII_MA_CP_CONNECTION_LAYOUT_ENTRY_DATA_T       atEntries[128];
} __TLR_PACKED_POST SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_DATA_T;

#define SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_MIN_SIZE (2*sizeof(TLR_UINT16) + sizeof(TLR_UINT8))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_CONNECTION_LAYOUT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_CONNECTION_LAYOUT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_CONNECTION_LAYOUT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_ADD_CONNECTION_LAYOUT_REQ_T          tReq;
  SIII_MA_CP_ADD_CONNECTION_LAYOUT_CNF_T          tCnf;
} SIII_MA_CP_ADD_CONNECTION_LAYOUT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTION_LAYOUT_REQ/SIII_MA_CP_CMD_GET_CONFIGURED_CONNECTION_LAYOUT_CNF
 *
 *          Add connection layout configuration
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_REQ_DATA_Ttag
{
  TLR_UINT16                                              usStartEntryIdx;
  TLR_UINT16                                              usSlaveAddress;
  TLR_UINT8                                               bConnectionInstance;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_DATA_Ttag
{
  TLR_UINT16                                              usStartEntryIdx;
  TLR_UINT16                                              usNumberOfAvailableEntries;
  SIII_MA_CP_CONNECTION_LAYOUT_ENTRY_DATA_T               atEntries[128];
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_DATA_T;

#define SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_MIN_SIZE (sizeof(TLR_UINT16)*2)
#define SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_ENTRY_COUNT(x) (((x) - SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_MIN_SIZE) / sizeof(SIII_MA_CP_CONNECTION_LAYOUT_ENTRY_DATA_T))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_REQ_T       tReq;
  SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_CNF_T       tCnf;
} SIII_MA_CP_GET_CONFIGURED_CONNECTION_LAYOUT_PCK_T;

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_INFO_REQ/SIII_MA_CP_CMD_GET_CONFIGURED_SLAVE_INFO_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_REQ_DATA_Ttag
{
  /* Slave Address */
  TLR_UINT16                                              usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_REQ_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_DATA_Ttag
{
  /* Slave Address */
  TLR_UINT16                                              usSlaveAddress;
  /* MDT SvcChannel Offset */
  TLR_UINT16                                              usMDTSvChOffset;
  /* AT SvcChannel Offset */
  TLR_UINT16                                              usATSvChOffset;
  /* MDT DeviceCtrl Offset */
  TLR_UINT16                                              usDevCtrlOffset;
  /* AT DeviceStatus Offset */
  TLR_UINT16                                              usDevStatOffset;
  /* Slave configuration flags */
  TLR_UINT32                                              ulSlaveConfigurationFlags;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_DATA_T;

#define SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_EMPTY_SIZE (sizeof(TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_REQ_T              tReq;
  SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_CNF_T              tCnf;
} SIII_MA_CP_GET_CONFIGURED_SLAVE_INFO_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_TIMING_CONFIG_REQ/SIII_MA_CP_CMD_GET_TIMING_CONFIG_CNF
 *
 *          Get current timing configuration in CP3/CP4
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_TIMING_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_TIMING_CONFIG_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_TIMING_CONFIG_CNF_DATA_Ttag
{
  /* communication relevant parameters { */
  /* S-0-1002 Communication Cycle Time (CP3/4) in ns */
  TLR_UINT32                                ulCommunicationCycleTime;
  /* S-0-1006 AT Transmission Starting Time in ns*/
  TLR_UINT32                                ulATTransmissionStartingTime;
  /* S-0-1017 NRT transmission time (t6 & t7) in ns */
  TLR_UINT32                                ulTransmissionTime_t6;
  TLR_UINT32                                ulTransmissionTime_t7;
  /* S-0-1008 Command value valid time (t3) in ns */
  TLR_UINT32                                ulCommandValueValidTime;
  /* S-0-1007 Feedback acquisition capture point (t4) in ns */
  TLR_UINT32                                ulSynchronizationTime;
  /* S-0-1027.0.1 NRT channel MTU */
  TLR_UINT16                                usNRTChannelMTU;
  /* } */

  TLR_UINT16                                usReserved;

  /* master internal handling parameters { */
  /* master MDT buffer access time point in ns */
  TLR_UINT32                                ulMDTBufferAccessTimePoint;
  /* master AT buffer access start time point in ns */
  TLR_UINT32                                ulATBufferAccessStartTimePoint;
  /* master AT buffer access end time point in ns */
  TLR_UINT32                                ulATBufferAccessEndTimePoint;
  /* } */
} __TLR_PACKED_POST SIII_MA_CP_GET_TIMING_CONFIG_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_TIMING_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_GET_TIMING_CONFIG_CNF_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_TIMING_CONFIG_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_TIMING_CONFIG_PCK_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_GET_TIMING_CONFIG_REQ_T        tReq;
  SIII_MA_CP_GET_TIMING_CONFIG_CNF_T        tCnf;
} SIII_MA_CP_GET_TIMING_CONFIG_PCK_T;

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_CONFIGURE_MASTER_REQ/SIII_MA_CP_CMD_CONFIGURE_MASTER_CNF
 *
 *          Reconfigure master parameters
 *
 * Requirement: master is in NRT mode
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_MASTER_REQ_DATA_Ttag
{
  TLR_UINT32                    ulConfigurationFlags;
  TLR_UINT32                    ulBusyTimeout;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_MASTER_REQ_DATA_T;

enum SIII_MA_CP_CONFIGURE_MASTER_CFG_FLAGS_Etag
{
  MSK_SIII_MA_CP_CONFIGURE_MASTER_CFG_FLAGS_SET_COMMUNICATION_VERSION       = 0x00000001,
  MSK_SIII_MA_CP_CONFIGURE_MASTER_CFG_FLAGS_SET_MDT_4_CP1_2                 = 0x00000002,
  /* the following value is outdated and has no effect */
  MSK_SIII_MA_CP_CONFIGURE_MASTER_CFG_FLAGS_SET_REMOTE_ADDRESS_ALLOCATION   = 0x00000004,

  MSK_SIII_MA_CP_CONFIGURE_MASTER_CFG_FLAGS_SET_BUSY_TIMEOUT                = 0x00000100
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_MASTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_CONFIGURE_MASTER_REQ_DATA_T            tData;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_MASTER_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_MASTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_MASTER_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CONFIGURE_MASTER_PCK_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_CP_CONFIGURE_MASTER_REQ_T tReq;
  SIII_MA_CP_CONFIGURE_MASTER_CNF_T tCnf;
} SIII_MA_CP_CONFIGURE_MASTER_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_REOPEN_CONFIGURATION_REQ/SIII_MA_CP_CMD_REOPEN_CONFIGURATION_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_REOPEN_CONFIGURATION_REQ_DATA_Ttag
{
  TLR_UINT32 ulReOpenFlags; /* reserved for future use, set to zero */
} __TLR_PACKED_POST SIII_MA_CP_REOPEN_CONFIGURATION_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_REOPEN_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_REOPEN_CONFIGURATION_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_REOPEN_CONFIGURATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_REOPEN_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_REOPEN_CONFIGURATION_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_REOPEN_CONFIGURATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_REOPEN_CONFIGURATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_REOPEN_CONFIGURATION_REQ_T       tReq;
  SIII_MA_CP_REOPEN_CONFIGURATION_CNF_T       tCnf;
} SIII_MA_CP_REOPEN_CONFIGURATION_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_BEGIN_CONFIGURATION_REQ/SIII_MA_CP_CMD_BEGIN_CONFIGURATION_CNF
 *
 *          Begin a configuration data set
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_BEGIN_CONFIGURATION_REQ_DATA_Ttag
{
  /* S-0-1002 Communication Cycle Time (CP3/4) */
  TLR_UINT32    ulCommunicationCycleTime;

  /* S-0-1003 Communication Timeout */
  TLR_UINT32    ulCommunicationTimeoutCP3_4;

  /* S-0-1008 Command value valid time (t3) */
  TLR_UINT32    ulCommandValueValidTime;

  /* S-0-1006 AT Transmission Starting Time */
  TLR_UINT32    ulATTransmissionStartingTime;

  /* S-0-1017 NRT transmission time (t6 & t7) */
  TLR_UINT32    ulTransmissionTime_t6;
  TLR_UINT32    ulTransmissionTime_t7;

  /* S-0-1007 Feedback acquisition capture point (t4) */
  TLR_UINT32    ulSynchronizationTime;



  /* S-0-1023 Sync Jitter */
  TLR_UINT32    ulSyncJitter;

  /* S-0-1027.0.1 NRT channel MTU */
  TLR_UINT16    usNRTChannelMTU;

  /* Process Data Output Size (MDT) */
  TLR_UINT32    ulProcessDataOutputSize;

  /* Process Data Input Size (AT) */
  TLR_UINT32    ulProcessDataInputSize;

  /* Minimum Cycle time to wait for in CP0 to detect all slaves (minimum value 100) */
  TLR_UINT32    ulCP0_CycleWait_For_StableState;

  /* Stack Config Flags */
  TLR_UINT32    ulStackConfigurationFlags;

  TLR_UINT32    aulACFGReserved[8];
  /* S-0-1061 Maximum TSref Counter (valid values between 0 and 16383) (values unequal 0 require MSK_SIII_MA_CP_USE_SERCOS_TIME_EXTENDED_FIELD) */
  TLR_UINT32    ulMaximumTsRefCounter;
  /* communication cycle time for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_CommunicationCycleTime;
  /* AT transmission starting time for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_ATTransmissionStartingTime;
  /* NRT transmission time (t6) for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_TransmissionTime_t6;
  /* NRT transmission time (t7) for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_TransmissionTime_t7;

  TLR_UINT32    aulACFGReserved2[3];

} __TLR_PACKED_POST SIII_MA_CP_BEGIN_CONFIGURATION_REQ_DATA_T;

enum SIII_MA_CP_STACK_CONFIGURATION_FLAGS_Etag
{
  MSK_SIII_MA_CP_BEGIN_CONFIGURATION_STACK_CFG_FLAGS_CP3_CP4_EXTERNALLY_TRIGGERED       = 0x00000001,
  MSK_SIII_MA_CP_USE_EXTERNAL_TRIGGER_FOR_CP3_CP4                                       = 0x00000001,
  MSK_SIII_MA_CP_USE_SERCOS_TIME_EXTENDED_FIELD                                         = 0x00000002,

  MSK_SIII_MA_CP_USE_AUTOCFG_CALCULATION                                                = 0x00000004,
/* If AutoCfg calculation is not selected, the following packets are allowed:
 * SIII_MA_CP_CMD_ADD_SLAVE_REQ
 * SIII_MA_CP_CMD_ADD_FIXCFG_SLAVE_REQ
 * SIII_MA_CP_CMD_ADD_VARCFG_SLAVE_REQ
 * SIII_MA_CP_CMD_ADD_CONNECTION_REQ
 *
 * If AutoCfg calculation is selected, the following packets are allowed:
 * SIII_MA_CP_CMD_AUTOCFG_ADD_FIXCFG_SLAVE_REQ
 * SIII_MA_CP_CMD_AUTOCFG_ADD_VARCFG_SLAVE_REQ
 * SIII_MA_CP_CMD_AUTOCFG_ADD_CONNECTION_REQ
 */

  MSK_SIII_MA_CP_AUTOCFG_NRT_CFG_TYPE                                                   = 0x00000018,
  VAL_SIII_MA_CP_AUTOCFG_NRT_IS_OFF                                                     = 0x00000000,
  VAL_SIII_MA_CP_AUTOCFG_MDT_AT_NRT                                                     = 0x00000008,
  VAL_SIII_MA_CP_AUTOCFG_MDT_NRT_AT                                                     = 0x00000010,
  VAL_SIII_MA_CP_AUTOCFG_MDT_NRT_AT_CYC_END                                             = 0x00000018,

/* set this flag if Timing should be calculated alongside enabled MSK_SIII_MA_CP_USE_AUTOCFG_CALCULATION */
  MSK_SIII_MA_CP_USE_AUTOCFG_TIMING                                                     = 0x00000020,

  MSK_SIII_MA_CP_ENABLE_INTERNAL_SYNC_CCON                                              = 0x00000040,
/* the following flag enables internal handling of Connection valid (only evaluated when MSK_SIII_MA_CP_ENABLE_INTERNAL_SYNC_CCON is set) */
  MSK_SIII_MA_CP_ENABLE_INTERNAL_CCON_VALID                                             = 0x00000080,

  MSK_SIII_MA_CP_AUTOCFG_MINIMUM_COMM_CYCLE_TIME                                        = 0x00000100,

  MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION                                       = 0x00000200,

  /* the following flag enables use of a hardware timer to know when the AT Rx Window End has been reached
   * Recommended to be set by new applications */
  MSK_SIII_MA_CP_USE_AT_RECV_TIMER                                                      = 0x00000400,

  MSK_SIII_MA_CP_USE_PRESET_RING_DELAY_VALUE                                            = 0x00000800,

  MSK_SIII_MA_CP_USE_NEW_AUTOCFG_TIMING_ALGORITHM                                       = 0x00001000,

  /* internal flag, not to be used within API */
  MSK_SIII_MA_CP_INTERNALLY_RESERVED                                                    = 0x80000000,
};

/* older version of begin_config structure used for comparision against that version */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_BEGIN_CONFIGURATION_R1_REQ_DATA_Ttag
{
  /* S-0-1002 Communication Cycle Time (CP3/4) */
  TLR_UINT32    ulCommunicationCycleTime;

  /* S-0-1003 Communication Timeout */
  TLR_UINT32    ulCommunicationTimeoutCP3_4;

  /* S-0-1008 Command value valid time (t3) */
  TLR_UINT32    ulCommandValueValidTime;

  /* S-0-1006 AT Transmission Starting Time */
  TLR_UINT32    ulATTransmissionStartingTime;

  /* S-0-1017 NRT transmission time (t6 & t7) */
  TLR_UINT32    ulTransmissionTime_t6;
  TLR_UINT32    ulTransmissionTime_t7;

  /* S-0-1007 Synchronization time (t8) */
  TLR_UINT32    ulSynchronizationTime;



  /* S-0-1023 Sync Jitter */
  TLR_UINT32    ulSyncJitter;

  /* S-0-1027.0.1 NRT channel MTU */
  TLR_UINT16    usNRTChannelMTU;

  /* Process Data Output Size (MDT) */
  TLR_UINT32    ulProcessDataOutputSize;

  /* Process Data Input Size (AT) */
  TLR_UINT32    ulProcessDataInputSize;

  /* Minimum Cycle time to wait for in CP0 to detect all slaves (minimum value 100) */
  TLR_UINT32    ulCP0_CycleWait_For_StableState;

} __TLR_PACKED_POST SIII_MA_CP_BEGIN_CONFIGURATION_R1_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_BEGIN_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_BEGIN_CONFIGURATION_REQ_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_BEGIN_CONFIGURATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_BEGIN_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_BEGIN_CONFIGURATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_BEGIN_CONFIGURATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_BEGIN_CONFIGURATION_REQ_T          tReq;
  SIII_MA_CP_BEGIN_CONFIGURATION_CNF_T          tCnf;
} SIII_MA_CP_BEGIN_CONFIGURATION_PCK_T;

/******************************************************************************
 * Packet: SIII_MA_CP_CMD_MODIFY_CONFIG_PARAMS_REQ/SIII_MA_CP_CMD_MODIFY_CONFIG_PARAMS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONFIG_PARAMS_REQ_DATA_Ttag
{
  /* Stack Config Flags */
  TLR_UINT32    ulEnableStackConfigurationFlags;
  TLR_UINT32    ulDisableStackConfigurationFlags;

  /* Ring Delay Preset value (valid when MSK_SIII_MA_CP_USE_PRESET_RING_DELAY_VALUE is set) */
  TLR_UINT32    ulPresetRingDelay;

  /* communication cycle time for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_CommunicationCycleTime;
  /* AT transmission starting time for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_ATTransmissionStartingTime;
  /* NRT transmission time (t6) for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_TransmissionTime_t6;
  /* NRT transmission time (t7) for CP1/CP2 (valid when MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION is set) */
  TLR_UINT32    ulCP1_CP2_TransmissionTime_t7;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONFIG_PARAMS_REQ_DATA_T;

/* following bits are modifiable */
/*
  MSK_SIII_MA_CP_BEGIN_CONFIGURATION_STACK_CFG_FLAGS_CP3_CP4_EXTERNALLY_TRIGGERED       = 0x00000001,
  MSK_SIII_MA_CP_USE_EXTERNAL_TRIGGER_FOR_CP3_CP4                                       = 0x00000001,
  MSK_SIII_MA_CP_ENABLE_INTERNAL_SYNC_CCON                                              = 0x00000040,
  MSK_SIII_MA_CP_ENABLE_INTERNAL_CCON_VALID                                             = 0x00000080,
  MSK_SIII_MA_CP_ENABLE_CP1_CP2_PARAMETERS_OPTION                                       = 0x00000200,
  MSK_SIII_MA_CP_USE_PRESET_RING_DELAY_VALUE                                            = 0x00000800,
*/

typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONFIG_PARAMS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_MODIFY_CONFIG_PARAMS_REQ_DATA_T  tData;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONFIG_PARAMS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_MODIFY_CONFIG_PARAMS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_MODIFY_CONFIG_PARAMS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_MODIFY_CONFIG_PARAMS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;
  SIII_MA_CP_MODIFY_CONFIG_PARAMS_REQ_T       tReq;
  SIII_MA_CP_MODIFY_CONFIG_PARAMS_CNF_T       tCnf;
} SIII_MA_CP_MODIFY_CONFIG_PARAMS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_AUTOCFG_ADD_TIMING_LIMITS_REQ/SIII_MA_CP_CMD_AUTOCFG_ADD_TIMING_LIMITS_CNF
 *
 *          only needed when AutoCfg with timing calculation is enabled
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_REQ_DATA_Ttag
{
  TLR_UINT32                                      ulMinimumSlaveCommunicationCycleNs;
  /* S-0-1005 */
  TLR_UINT32                                      ulMaxProducerProcessingTimeNs;
  /* S-0-1037 */
  TLR_UINT32                                      ulMaxSlaveJitterNs;
  /* S-0-1047 */
  TLR_UINT32                                      ulMaxConsumerProcessingTimeNs;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_REQ_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_REQ_T      tReq;
  SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_CNF_T      tCnf;
} SIII_MA_CP_AUTOCFG_ADD_TIMING_LIMITS_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_END_CONFIGURATION_REQ/SIII_MA_CP_CMD_END_CONFIGURATION_CNF
 *
 *          End a configuration transfer, make new config data valid
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_END_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_END_CONFIGURATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_END_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_END_CONFIGURATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_END_CONFIGURATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_END_CONFIGURATION_REQ_T            tReq;
  SIII_MA_CP_END_CONFIGURATION_CNF_T            tCnf;
} SIII_MA_CP_END_CONFIGURATION_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ABORT_CONFIGURATION_REQ/SIII_MA_CP_CMD_ABORT_CONFIGURATION_CNF
 *
 *          Abort a configuration transfer
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ABORT_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ABORT_CONFIGURATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ABORT_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ABORT_CONFIGURATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ABORT_CONFIGURATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ABORT_CONFIGURATION_REQ_T          tReq;
  SIII_MA_CP_ABORT_CONFIGURATION_CNF_T          tCnf;
} SIII_MA_CP_ABORT_CONFIGURATION_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_SLAVE_REQ/SIII_MA_CP_CMD_ADD_SLAVE_CNF
 *
 *          Add a new slave data block to the opened configuration
 */

/* request packet */

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SLAVE_REQ_DATA_Ttag
{
  /* Slave Address */
  TLR_UINT16          usSlaveAddress;
  /* MDT SvcChannel Offset */
  TLR_UINT16          usMDTSvChOffset;
  /* AT SvcChannel Offset */
  TLR_UINT16          usATSvChOffset;
  /* MDT DeviceCtrl Offset */
  TLR_UINT16          usDevCtrlOffset;
  /* AT DeviceStatus Offset */
  TLR_UINT16          usDevStatOffset;
  /* Slave configuration flags */
  TLR_UINT32          ulSlaveConfigurationFlags;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SLAVE_REQ_DATA_T;

enum SIII_MA_CP_SLAVE_FLAGS_Etag
{
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_NO_PROC_CMD_RESET              = 0x00000001,    /* only in combination with SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_CHECK_IDN_LISTS */

  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_ENABLE_HOTPLUG                 = 0x00000002,

  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_FORCE_SCP_SYNC                 = 0x00000004,

  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_OPTIONAL_SLAVE                 = 0x00000008,

  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_EXEMPT_MDT_FROM_INTERNAL_CCON  = 0x00000010,
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_NO_MDT_SYNCHRONOUS_CCON_TOGGLE = 0x00000020,

  /* following two parameters are only active if SIII_MA_CP_CMD_ADD_SLAVE_IDENT_REQ has been used */
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_CHECK_VENDOR_CODE              = 0x00000040,
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_CHECK_DEVICE_ID                = 0x00000080,

  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_CHECK_IDN_LISTS                = 0x08000000,
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_ALLOW_SHORTER_SLAVE_CONN_LEN   = 0x10000000,
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_DO_NOT_USE_PROC_CMD_ACK_BIT    = 0x20000000,
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_DISABLE_S_0_1050_X_5_CHECK     = 0x40000000,
  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_DISABLE_FALLBACK_FG_DETECTION  = 0x80000000,

  SIII_MA_CP_ADD_SLAVE_REQ_FLAGS_SUPPORTED                      = 0xF80000FF
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SLAVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_SLAVE_REQ_DATA_T               tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SLAVE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_SLAVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_SLAVE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_SLAVE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_SLAVE_REQ_T                    tReq;
  SIII_MA_CP_ADD_SLAVE_CNF_T                    tCnf;
} SIII_MA_CP_ADD_SLAVE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_FIXCFG_SLAVE_REQ/SIII_MA_CP_CMD_ADD_FIXCFG_SLAVE_CNF
 *
 *          Add a new slave data block + connections to the opened configuration
 */

/* request packet */

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_Ttag
{
  TLR_UINT16            usTelegramOffset;               /* SIII style */
  TLR_UINT16            usConnectionLength;             /* connection length */
  TLR_UINT16            usConnCtrlProcessImageOffset;   /* ConnCtrl Process Image offset */
  TLR_UINT16            usRtDataProcessImageOffset;     /* RtData Process Image offset */
  TLR_UINT16            usFunctionType;                 /* function type */
} __TLR_PACKED_POST SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_DATA_Ttag
{
  /* Slave Address */
  TLR_UINT16          usSlaveAddress;
  /* MDT SvcChannel Offset */
  TLR_UINT16          usMDTSvChOffset;
  /* AT SvcChannel Offset */
  TLR_UINT16          usATSvChOffset;
  /* MDT DeviceCtrl Offset */
  TLR_UINT16          usDevCtrlOffset;
  /* AT DeviceStatus Offset */
  TLR_UINT16          usDevStatOffset;
  /* Slave configuration flags */
  TLR_UINT32          ulSlaveConfigurationFlags;

  /* Connection 0: AT */
  SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T tATConnection;

  /* Connection 1: MDT */
  SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T tMDTConnection;
} __TLR_PACKED_POST SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_FIXCFG_SLAVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_FIXCFG_SLAVE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_FIXCFG_SLAVE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_T             tReq;
  SIII_MA_CP_ADD_FIXCFG_SLAVE_CNF_T             tCnf;
} SIII_MA_CP_ADD_FIXCFG_SLAVE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_VARCFG_SLAVE_REQ/SIII_MA_CP_CMD_ADD_VARCFG_SLAVE_CNF
 *
 *          Add a new slave data block + connections to the opened configuration
 */

/* request packet */
typedef SIII_MA_CP_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_CONN_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_DATA_Ttag
{
  /* Slave Address */
  TLR_UINT16          usSlaveAddress;
  /* MDT SvcChannel Offset */
  TLR_UINT16          usMDTSvChOffset;
  /* AT SvcChannel Offset */
  TLR_UINT16          usATSvChOffset;
  /* MDT DeviceCtrl Offset */
  TLR_UINT16          usDevCtrlOffset;
  /* AT DeviceStatus Offset */
  TLR_UINT16          usDevStatOffset;
  /* Slave configuration flags */
  TLR_UINT32          ulSlaveConfigurationFlags;

  SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_CONN_DATA_T atConnections[256]; /* actually can be sized between 1 to 256 elements (ulLen = 14 + number of connections * 4) */
} __TLR_PACKED_POST SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_DATA_T;

#define SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_HEADER_DATA_SIZE 14

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_DATA_T        tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_VARCFG_SLAVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_VARCFG_SLAVE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_VARCFG_SLAVE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_VARCFG_SLAVE_REQ_T             tReq;
  SIII_MA_CP_ADD_VARCFG_SLAVE_CNF_T             tCnf;
} SIII_MA_CP_ADD_VARCFG_SLAVE_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_CONNECTION_REQ/SIII_MA_CP_CMD_ADD_CONNECTION_CNF
 *
 *          Add a new slave connection data block to the opened configuration
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_CONNECTION_REQ_DATA_Ttag
{
  /* Slave Address */
  TLR_UINT16            usSlaveAddress;
  TLR_UINT8             bConnectionInstance;            /* Connection Instance */
  TLR_UINT16            usTelegramOffset;               /* SIII style */
  TLR_UINT16            usConnectionLength;             /* connection length */
  TLR_UINT16            usConnCtrlProcessImageOffset;   /* ConnCtrl Process Image offset */
  TLR_UINT16            usRtDataProcessImageOffset;     /* RtData Process Image offset */
  TLR_UINT16            usFunctionType;                 /* function type (see SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_*) */
} __TLR_PACKED_POST SIII_MA_CP_ADD_CONNECTION_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_CONNECTION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_CONNECTION_REQ_DATA_T          tData;
} __TLR_PACKED_POST SIII_MA_CP_ADD_CONNECTION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_CONNECTION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_CONNECTION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_CONNECTION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_CONNECTION_REQ_T               tReq;
  SIII_MA_CP_ADD_CONNECTION_CNF_T               tCnf;
} SIII_MA_CP_ADD_CONNECTION_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_AUTOCFG_ADD_FIXCFG_SLAVE_REQ/SIII_MA_CP_CMD_AUTOCFG_ADD_FIXCFG_SLAVE_CNF
 * Packet:  SIII_MA_CP_CMD_AUTOCFG_ADD_VARCFG_SLAVE_REQ/SIII_MA_CP_CMD_AUTOCFG_ADD_VARCFG_SLAVE_CNF
 */

/* common */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_SLAVE_REQ_CONN_DATA_Ttag
{
  TLR_UINT16                    usConnectionNumber;             /* connection number */
  TLR_UINT16                    usConnectionLength;             /* connection length */
  TLR_UINT16                    usConnCtrlProcessImageOffset;   /* ConnCtrl Process Image offset */
  TLR_UINT16                    usRtDataProcessImageOffset;     /* RtData Process Image offset */
  TLR_UINT16                    usFunctionType;                 /* function type (see SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_*) */
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_SLAVE_REQ_CONN_DATA_T;

typedef SIII_MA_CP_AUTOCFG_ADD_SLAVE_REQ_CONN_DATA_T SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T;
typedef SIII_MA_CP_AUTOCFG_ADD_SLAVE_REQ_CONN_DATA_T SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_CONN_DATA_T;

/**************************************
 * Packet:  SIII_MA_CP_CMD_AUTOCFG_ADD_FIXCFG_SLAVE_REQ
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_DATA_Ttag
{
  TLR_UINT16                    usSlaveAddress;
  TLR_UINT32                    ulSlaveConfigurationFlags;

  /* Connection 0: AT */
  SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T tATConnection;

  /* Connection 1: MDT */
  SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_CONN_DATA_T tMDTConnection;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_DATA_T      tData;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_REQ_T           tReq;
  SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_CNF_T           tCnf;
} SIII_MA_CP_AUTOCFG_ADD_FIXCFG_SLAVE_PCK_T;


/**************************************
 * Packet:  SIII_MA_CP_CMD_AUTOCFG_ADD_VARCFG_SLAVE_REQ
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_DATA_Ttag
{
  TLR_UINT16                    usSlaveAddress;
  TLR_UINT32                    ulSlaveConfigurationFlags;

  SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_CONN_DATA_T atConnections[256]; /* actual size depending on ulLen */
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_DATA_T;

#define SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_HEADER_DATA_SIZE 6

typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_DATA_T      tData;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_CNF_T;


/* packet union */
typedef union SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_REQ_T           tReq;
  SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_CNF_T           tCnf;
} SIII_MA_CP_AUTOCFG_ADD_VARCFG_SLAVE_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_AUTOCFG_ADD_CONNECTION_REQ/SIII_MA_CP_CMD_AUTOCFG_ADD_CONNECTION_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_CONNECTION_REQ_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT8                                         bConnectionInstance;
  TLR_UINT8                                         bReserved;
  TLR_UINT16                                        usConnectionNumber;
  TLR_UINT16                                        usConnectionLength;
  TLR_UINT16                                        usConnCtrlProcessImageOffset;
  TLR_UINT16                                        usRtDataProcessImageOffset;
  TLR_UINT16                                        usFunctionType;   /* function type (see SIII_MA_CP_ADD_CONNECTION_FUNCTION_TYPE_*) */
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_CONNECTION_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_CONNECTION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_AUTOCFG_ADD_CONNECTION_REQ_DATA_T      tData;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_CONNECTION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_AUTOCFG_ADD_CONNECTION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
} __TLR_PACKED_POST SIII_MA_CP_AUTOCFG_ADD_CONNECTION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_AUTOCFG_ADD_CONNECTION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_AUTOCFG_ADD_CONNECTION_REQ_T           tReq;
  SIII_MA_CP_AUTOCFG_ADD_CONNECTION_CNF_T           tCnf;
} SIII_MA_CP_AUTOCFG_ADD_CONNECTION_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_INITCMD_COUNT_REQ/SIII_MA_CP_CMD_GET_INITCMD_COUNT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_COUNT_REQ_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_COUNT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_COUNT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_INITCMD_COUNT_REQ_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_COUNT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_COUNT_CNF_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT32                                        ulNumInitCmds;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_COUNT_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_COUNT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_INITCMD_COUNT_CNF_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_COUNT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_INITCMD_COUNT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_INITCMD_COUNT_REQ_T                tReq;
  SIII_MA_CP_GET_INITCMD_COUNT_CNF_T                tCnf;
} SIII_MA_CP_GET_INITCMD_COUNT_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_INITCMD_INFO_REQ/SIII_MA_CP_CMD_GET_INITCMD_INFO_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_INFO_REQ_DATA_Ttag
{
  TLR_UINT16                                        usSlaveAddress;
  TLR_UINT32                                        ulInitCmdIdx;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_INFO_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_INITCMD_INFO_REQ_DATA_T            tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_INFO_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_INFO_CNF_DATA_Ttag
{
  TLR_UINT16            usSlaveAddress;
  TLR_UINT32            ulInitCmdIdx;
  TLR_UINT16            usTransitionFlags;
  TLR_UINT16            usAction;
  TLR_UINT32            ulIDN;
  TLR_UINT8             bElementId;
  TLR_UINT32            ulLength;
  TLR_UINT16            usDefineLabel;                  /* 0 means no label, anything else is used to jump to */
  TLR_UINT16            usGotoLabelOnSuccess;           /* 0 means no jump i.e. next initcmd is executed */
  TLR_UINT16            usGotoLabelOnNoIdnError;        /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnIdnError;          /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnCmpError;          /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnProcCmdError;      /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnWriteError;        /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnReadError;         /* 0 means no jump i.e. default compare error handling is used */
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_INFO_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_INITCMD_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_INITCMD_INFO_CNF_DATA_T            tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_INITCMD_INFO_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_INITCMD_INFO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;
  SIII_MA_CP_GET_INITCMD_INFO_REQ_T                 tReq;
  SIII_MA_CP_GET_INITCMD_INFO_CNF_T                 tCnf;
} SIII_MA_CP_GET_INITCMD_INFO_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_ADD_IDN_INITCMD_REQ/SIII_MA_CP_CMD_ADD_IDN_INITCMD_CNF
 *
 *          Append a new IDN Init Cmd
 *
 *  Two different transfer methods exists:
 *
 *  Small transfers that fit in a single packet
 *
 *    SIII_MA_CP_CMD_ADD_INITCMD_REQ( Ext == NONE)
 *
 *    SIII_MA_CP_CMD_ADD_INITCMD_CNF( Ext == NONE)
 *
 *
 *  Big transfers that need multiple packets for transfer
 *
 *    1. SIII_MA_CP_CMD_ADD_INITCMD_REQ( Ext == FIRST)
 *
 *    1a. SIII_MA_CP_CMD_ADD_INITCMD_CNF( Ext == FIRST)
 *
 *    2. if required: multiple SIII_MA_CP_CMD_ADD_INITCMD_REQ( Ext == MIDDLE) depending on initcmd size
 *
 *    2a. SIII_MA_CP_CMD_ADD_INITCMD_CNF( Ext == MIDDLE)
 *
 *    3. SIII_MA_CP_CMD_ADD_INITCMD_REQ( Ext == LAST)
 *
 *    3a. SIII_MA_CP_CMD_ADD_INITCMD_CNF( Ext == LAST)
 *
 */

/* request packet */
#define SIII_MA_CP_ADD_IDN_INITCMD_REQ_MIN_DATA_BUFFER_SIZE 1024

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_INITCMD_REQ_DATA_Ttag
{
  TLR_UINT16            usSlaveAddress;                 /* Slave Address */
  TLR_UINT16            usTransitionFlags;              /* Transition flags */
  TLR_UINT16            usAction;                       /* Action to be performed */
  TLR_UINT32            ulIDN;                          /* IDN number */
  TLR_UINT8             bElementId;                     /* Element Id */
  TLR_UINT32            ulLength;                       /* Length of data */
  /* data follows here */
} __TLR_PACKED_POST SIII_MA_CP_ADD_INITCMD_REQ_DATA_T;

/* Transition Flags */
enum SIII_MA_CP_INITCMD_TRANSITION_FLAGS_Etag
{
  SIII_MA_CP_ADD_INITCMD_REQ_TRANSITION_FLAGS_EXEC_CP2_CP3                = 0x0004,
  SIII_MA_CP_ADD_INITCMD_REQ_TRANSITION_FLAGS_EXEC_CP3_CP4                = 0x0008,
  SIII_MA_CP_ADD_INITCMD_REQ_TRANSITION_FLAGS_EXEC_CP4                    = 0x0010, /* reserved for future use */
  SIII_MA_CP_ADD_INITCMD_REQ_TRANSITION_FLAGS_NO_IDN_ACCEPTABLE           = 0x0020,
  SIII_MA_CP_ADD_INITCMD_REQ_TRANSITION_FLAGS_VALID_MASK                  = 0x003C
};

/* Access mode */
enum SIII_MA_CP_INITCMD_ACTION_Etag
{
  SIII_MA_CP_ADD_INITCMD_REQ_ACTION_WRITE                       = 1,
  SIII_MA_CP_ADD_INITCMD_REQ_ACTION_COMPARE                     = 2,
  SIII_MA_CP_ADD_INITCMD_REQ_ACTION_COMMAND                     = 3
};

/* Element Id */
enum SIII_MA_CP_INITCMD_ELEMENT_ID_Etag
{
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_OPEN_IDN                = 1,
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_NAME                    = 2,
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_ATTRIBUTE               = 3,
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_UNIT                    = 4,
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_MINIMUM                 = 5,
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_MAXIMUM                 = 6,
  SIII_MA_CP_ADD_INITCMD_REQ_ELEMENT_ID_OPDATA                  = 7
};

/* Predefined Labels */
enum SIII_MA_CP_INITCMD_LABEL_Etag
{
  SIII_MA_CP_INITCMD_LABEL_NO_LABEL = 0,

  SIII_MA_CP_INITCMD_LABEL_PREDEFINED_LABELS_START = 65000,
  SIII_MA_CP_INITCMD_LABEL_NEXT_INITCMD = 65534,
  SIII_MA_CP_INITCMD_LABEL_END_OF_LIST = 65535
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_INITCMD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_INITCMD_REQ_DATA_T             tData;
  TLR_UINT8                                     abData[SIII_MA_CP_ADD_IDN_INITCMD_REQ_MIN_DATA_BUFFER_SIZE];
} __TLR_PACKED_POST SIII_MA_CP_ADD_INITCMD_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_INITCMD_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_INITCMD_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_INITCMD_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_ADD_INITCMD_REQ_T                  tReq;
  SIII_MA_CP_ADD_INITCMD_CNF_T                  tCnf;
} SIII_MA_CP_ADD_INITCMD_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_ADD_INITCMD_EXT_REQ/SIII_MA_CP_CMD_ADD_INITCMD_EXT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_INITCMD_EXT_REQ_DATA_Ttag
{
  TLR_UINT16            usSlaveAddress;                 /* Slave Address */
  TLR_UINT16            usTransitionFlags;              /* Transition flags */
  TLR_UINT16            usAction;                       /* Action to be performed */
  TLR_UINT32            ulIDN;                          /* IDN number */
  TLR_UINT8             bElementId;                     /* Element Id */
  TLR_UINT32            ulLength;                       /* Length of data */
  TLR_UINT16            usDefineLabel;                  /* 0 means no label, anything else is used to jump to */
  TLR_UINT16            usGotoLabelOnSuccess;           /* 0 means no jump i.e. next initcmd is executed */
  TLR_UINT16            usGotoLabelOnNoIdnError;        /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnIdnError;          /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnCmpError;          /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnProcCmdError;      /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnWriteError;        /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnReadError;         /* 0 means no jump i.e. default compare error handling is used */
} __TLR_PACKED_POST SIII_MA_CP_ADD_INITCMD_EXT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_INITCMD_EXT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_ADD_INITCMD_EXT_REQ_DATA_T                   tData;
  TLR_UINT8                                               abData[SIII_MA_CP_ADD_IDN_INITCMD_REQ_MIN_DATA_BUFFER_SIZE];
} __TLR_PACKED_POST SIII_MA_CP_ADD_INITCMD_EXT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_ADD_INITCMD_EXT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_ADD_INITCMD_EXT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_ADD_INITCMD_EXT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_ADD_INITCMD_EXT_REQ_T                        tReq;
  SIII_MA_CP_ADD_INITCMD_EXT_CNF_T                        tCnf;
} SIII_MA_CP_ADD_INITCMD_EXT_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_INSERT_INITCMD_REQ/SIII_MA_CP_CMD_INSERT_INITCMD_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_INSERT_INITCMD_REQ_DATA_Ttag
{
  TLR_UINT16            usSlaveAddress;                 /* Slave Address */
  TLR_UINT16            usTransitionFlags;              /* Transition flags */
  TLR_UINT16            usAction;                       /* Action to be performed */
  TLR_UINT32            ulIDN;                          /* IDN number */
  TLR_UINT8             bElementId;                     /* Element Id */
  TLR_UINT32            ulLength;                       /* Length of data */
  TLR_UINT32            ulBeforeInitCmdIdx;
  TLR_UINT16            usDefineLabel;                  /* 0 means no label, anything else is used to jump to */
  TLR_UINT16            usGotoLabelOnSuccess;           /* 0 means no jump i.e. next initcmd is executed */
  TLR_UINT16            usGotoLabelOnNoIdnError;        /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnIdnError;          /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnCmpError;          /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnProcCmdError;      /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnWriteError;        /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnReadError;         /* 0 means no jump i.e. default compare error handling is used */
} __TLR_PACKED_POST SIII_MA_CP_INSERT_INITCMD_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_INSERT_INITCMD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_INSERT_INITCMD_REQ_DATA_T                    tData;
  TLR_UINT8                                               abData[SIII_MA_CP_ADD_IDN_INITCMD_REQ_MIN_DATA_BUFFER_SIZE];
} __TLR_PACKED_POST SIII_MA_CP_INSERT_INITCMD_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_INSERT_INITCMD_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_INSERT_INITCMD_CNF_T;


/* packet union */
typedef union SIII_MA_CP_INSERT_INITCMD_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_INSERT_INITCMD_REQ_T                         tReq;
  SIII_MA_CP_INSERT_INITCMD_CNF_T                         tCnf;
} SIII_MA_CP_INSERT_INITCMD_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_REPLACE_INITCMD_REQ/SIII_MA_CP_CMD_REPLACE_INITCMD_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_REPLACE_INITCMD_REQ_DATA_Ttag
{
  TLR_UINT16            usSlaveAddress;                 /* Slave Address */
  TLR_UINT16            usTransitionFlags;              /* Transition flags */
  TLR_UINT16            usAction;                       /* Action to be performed */
  TLR_UINT32            ulIDN;                          /* IDN number */
  TLR_UINT8             bElementId;                     /* Element Id */
  TLR_UINT32            ulLength;                       /* Length of data */
  TLR_UINT32            ulReplaceInitCmdIdx;
  TLR_UINT16            usDefineLabel;                  /* 0 means no label, anything else is used to jump to */
  TLR_UINT16            usGotoLabelOnSuccess;           /* 0 means no jump i.e. next initcmd is executed */
  TLR_UINT16            usGotoLabelOnNoIdnError;        /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnIdnError;          /* 0 means no jump i.e. default idn error handling is used */
  TLR_UINT16            usGotoLabelOnCmpError;          /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnProcCmdError;      /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnWriteError;        /* 0 means no jump i.e. default compare error handling is used */
  TLR_UINT16            usGotoLabelOnReadError;         /* 0 means no jump i.e. default compare error handling is used */
} __TLR_PACKED_POST SIII_MA_CP_REPLACE_INITCMD_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_REPLACE_INITCMD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_REPLACE_INITCMD_REQ_DATA_T                   tData;
  TLR_UINT8                                               abData[SIII_MA_CP_ADD_IDN_INITCMD_REQ_MIN_DATA_BUFFER_SIZE];
} __TLR_PACKED_POST SIII_MA_CP_REPLACE_INITCMD_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_REPLACE_INITCMD_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_REPLACE_INITCMD_CNF_T;


/* packet union */
typedef union SIII_MA_CP_REPLACE_INITCMD_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;
  SIII_MA_CP_REPLACE_INITCMD_REQ_T                        tReq;
  SIII_MA_CP_REPLACE_INITCMD_CNF_T                        tCnf;
} SIII_MA_CP_REPLACE_INITCMD_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_CONFIGURE_FRAME_SIZES_REQ/SIII_MA_CP_CMD_CONFIGURE_FRAME_SIZES_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_FRAME_SIZES_REQ_DATA_Ttag
{
  TLR_UINT16 ausMDTSizes[4];
  /* MDT0 has to be configured with minimum 40 at all times,
   * MDT1-3 can be set to 0
   * If no slave is configured to be within any of those frames, these will be switched off.
   */
  TLR_UINT16 ausATSizes[4];
  /* AT0 has to be configured with minimum 40 at all times,
   * AT1-3 can be set to 0
   * If no slave is configured to be within any of those frames, these will be switched off.
   */
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_FRAME_SIZES_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_FRAME_SIZES_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_CONFIGURE_FRAME_SIZES_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_FRAME_SIZES_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_FRAME_SIZES_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_FRAME_SIZES_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CONFIGURE_FRAME_SIZES_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_CONFIGURE_FRAME_SIZES_REQ_T        tReq;
  SIII_MA_CP_CONFIGURE_FRAME_SIZES_CNF_T        tCnf;
} SIII_MA_CP_CONFIGURE_FRAME_SIZES_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_UNLOAD_CONFIGURATION_REQ/SIII_MA_CP_CMD_UNLOAD_CONFIGURATION_CNF
 */

/* request packet */
typedef struct __TLR_PACKED_PRE SIII_MA_CP_UNLOAD_CONFIGURATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_UNLOAD_CONFIGURATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_UNLOAD_CONFIGURATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} __TLR_PACKED_POST SIII_MA_CP_UNLOAD_CONFIGURATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_UNLOAD_CONFIGURATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_UNLOAD_CONFIGURATION_REQ_T         tReq;
  SIII_MA_CP_UNLOAD_CONFIGURATION_CNF_T         tCnf;
} SIII_MA_CP_UNLOAD_CONFIGURATION_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_CONNECTION_INFO_REQ/SIII_MA_CP_CMD_GET_CONNECTION_INFO_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_INFO_REQ_DATA_Ttag
{
  TLR_UINT16                                    usSlaveAddress;
  TLR_UINT8                                     bConnectionInstance;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_INFO_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_GET_CONNECTION_INFO_REQ_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_INFO_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_INFO_CNF_DATA_Ttag
{
  TLR_UINT16                                    usType;
  /* following three fields are only valid if connection is mapped into DPM */
  TLR_UINT16                                    usConnCtrlOffset;
  TLR_UINT16                                    usRtDataOffset;
  TLR_UINT16                                    usConnectionLength;
  /* telegram assignment: valid for all connection types */
  TLR_UINT16                                    usTelegramAssignment;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_INFO_CNF_DATA_T;

enum SIII_MA_CP_CONNECTION_TYPE_Etag
{
  SIII_MA_CP_GET_CONNECTION_INFO_TYPE_OTHER                 = 0,     /* Other connection type. NOT in process data image */
  SIII_MA_CP_GET_CONNECTION_INFO_TYPE_RTDATA_MDT            = 1,     /* MDT data in process data image */
  SIII_MA_CP_GET_CONNECTION_INFO_TYPE_RTDATA_AT             = 2,     /* AT data in process data image */
  SIII_MA_CP_GET_CONNECTION_INFO_TYPE_RTDATA_CC             = 3,     /* AT data related to CC / NOT in process data image */
  SIII_MA_CP_GET_CONNECTION_INFO_TYPE_SCP_SYSTIME_CONTROL   = 4,     /* only reported when asked for master internal connection with address 65535 */
  SIII_MA_CP_GET_CONNECTION_INFO_TYPE_SCP_SYSTIME_STATUS    = 5,     /* only reported when asked for master internal connection with address 65535 */
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_CONNECTION_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_GET_CONNECTION_INFO_CNF_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_CONNECTION_INFO_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_CONNECTION_INFO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_MA_CP_GET_CONNECTION_INFO_REQ_T          tReq;
  SIII_MA_CP_GET_CONNECTION_INFO_CNF_T          tCnf;
} SIII_MA_CP_GET_CONNECTION_INFO_PCK_T;


/**********************************************************************************************************************

  #####                             #              ##              ####                                            ##
 #     #                                            #             #    #                   #                        #
 #                                                  #            #                         #                        #
 #       ######   #####   #####   ###     ####      #            #        #####  ## ##    ####   ### ##   #####     #     #####
  #####   #    # #     # #     #    #         #     #            #       #     #  ##  #    #       ##  # #     #    #    #     #
       #  #    # ####### #          #     #####     #            #       #     #  #   #    #       #     #     #    #     ###
       #  #    # #       #          #    #    #     #            #       #     #  #   #    #       #     #     #    #        ##
 #     #  #    # #     # #     #    #    #    #     #             #    # #     #  #   #    #  #    #     #     #    #    #     #
  #####   #####   #####   #####   #####   #### #  #####            ####   #####  ### ###    ##   #####    #####   #####   #####
          #
         ###

*/
#define SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_PRED_REQ                  0x4884
#define SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_PRED_CNF                  0x4885

#define SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_SUCC_REQ                  0x4886
#define SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_SUCC_CNF                  0x4887

/* 0x488A-0x488F reserved for internal use */


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_PRED_REQ/SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_PRED_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_REQ_DATA_T       tData;
} __TLR_PACKED_POST SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_REQ_T            tReq;
  SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_CNF_T            tCnf;
} SIII_MA_CP_SET_TO_LOOPBACK_TO_PRED_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_SUCC_REQ/SIII_MA_CP_CMD_SET_TO_LOOPBACK_TO_SUCC_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_REQ_DATA_Ttag
{
  TLR_UINT16 usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_REQ_DATA_T       tData;
} __TLR_PACKED_POST SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_REQ_T;

/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
} __TLR_PACKED_POST SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_CNF_T;


/* packet union */
typedef union SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_PCK_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;
  SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_REQ_T            tReq;
  SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_CNF_T            tCnf;
} SIII_MA_CP_SET_TO_LOOPBACK_TO_SUCC_PCK_T;


/**********************************************************************************************************************

 ######                           #####
  #    #                         #     #
  #    #                         #
  #    # ##  ##   #####          #        #####   ####   ## ##
  #####   #   #  #     #          #####  #     #      #   ##  #
  #    #  #   #   ###                  # #        #####   #   #
  #    #  #   #      ##                # #       #    #   #   #
  #    #  #  ##  #     #         #     # #     # #    #   #   #
 ######    ## ##  #####           #####   #####   #### # ### ###



`*/

/* 0x4890-0x4897 - Bus Scan */
#define SIII_MA_CP_CMD_START_BUS_SCAN_REQ           0x4890
#define SIII_MA_CP_CMD_START_BUS_SCAN_CNF           0x4891

#define SIII_MA_CP_CMD_GET_BUS_SCAN_INFO_REQ        0x4892
#define SIII_MA_CP_CMD_GET_BUS_SCAN_INFO_CNF        0x4893


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_START_BUS_SCAN_REQ/SIII_MA_CP_CMD_START_BUS_SCAN_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_START_BUS_SCAN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                         tHead;
} __TLR_PACKED_POST SIII_MA_CP_START_BUS_SCAN_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_START_BUS_SCAN_CNF_DATA_Ttag
{
  TLR_UINT32                                                  ulFoundSlaves;
} __TLR_PACKED_POST SIII_MA_CP_CMD_START_BUS_SCAN_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_START_BUS_SCAN_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                         tHead;
  SIII_MA_CP_CMD_START_BUS_SCAN_CNF_DATA_T                    tData;
} __TLR_PACKED_POST SIII_MA_CP_START_BUS_SCAN_CNF_T;


/* packet union */
typedef union SIII_MA_CP_START_BUS_SCAN_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_START_BUS_SCAN_REQ_T tReq;
  SIII_MA_CP_START_BUS_SCAN_CNF_T tCnf;
} SIII_MA_CP_START_BUS_SCAN_PCK_T;


/******************************************************************************
 * Packet: SIII_MA_CP_CMD_GET_BUS_SCAN_INFO_REQ/SIII_MA_CP_CMD_GET_BUS_SCAN_INFO_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_BUS_SCAN_INFO_REQ_DATA_Ttag
{
  TLR_UINT16                                                  usTopologyAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_BUS_SCAN_INFO_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_BUS_SCAN_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                         tHead;
  SIII_MA_CP_GET_BUS_SCAN_INFO_REQ_DATA_T                     tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_BUS_SCAN_INFO_REQ_T;


/* confirmation packet */
#define SIII_MA_CP_MAX_DVC_ID_LEN                             256

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_BUS_SCAN_INFO_CNF_DATA_Ttag
{
  TLR_UINT16                                                  usSercosAddress;
  TLR_UINT16                                                  usVendorCode;
  TLR_STR                                                     abDeviceID[SIII_MA_CP_MAX_DVC_ID_LEN];
  TLR_UINT8                                                   bZero;
  TLR_UINT32                                                  ulSlaveFlags;
} __TLR_PACKED_POST SIII_MA_CP_GET_BUS_SCAN_INFO_CNF_DATA_T;

#define SIII_MA_CP_GET_BUS_SCAN_INFO_SLAVE_FLAGS_SERCOS_ADDR_MANUALLY_CONFIGURED        0x00000001


typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_BUS_SCAN_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                         tHead;
  SIII_MA_CP_GET_BUS_SCAN_INFO_CNF_DATA_T                     tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_BUS_SCAN_INFO_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_BUS_SCAN_INFO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_CP_GET_BUS_SCAN_INFO_REQ_T    tReq;
  SIII_MA_CP_GET_BUS_SCAN_INFO_CNF_T    tCnf;
} SIII_MA_CP_GET_BUS_SCAN_INFO_PCK_T;


/**********************************************************************************************************************
 */

/* 48C2-48DF for debugging diagnosis */
#define SIII_MA_CP_CMD_GET_IFG_INFORMATION_REQ      0x48C4
#define SIII_MA_CP_CMD_GET_IFG_INFORMATION_CNF      0x48C5

#define SIII_MA_CP_CMD_GET_TOPOLOGY_INFO_REQ        0x48C6
#define SIII_MA_CP_CMD_GET_TOPOLOGY_INFO_CNF        0x48C7

#define SIII_MA_CP_CMD_GET_XC_COUNTERS_REQ          0x48C8
#define SIII_MA_CP_CMD_GET_XC_COUNTERS_CNF          0x48C9

#define SIII_MA_CP_CMD_READ_FSM_TRACE_REQ           0x48CA
#define SIII_MA_CP_CMD_READ_FSM_TRACE_CNF           0x48CB

#define SIII_MA_CP_CMD_CLEAR_FSM_TRACE_REQ          0x8938
#define SIII_MA_CP_CMD_CLEAR_FSM_TRACE_CNF          0x8939

/* 0x893c internally used */
/* 0x893e internally used */
/* 0x8940 internally used */

#define SIII_MA_CP_CMD_GET_RING_DELAY_REQ           0x48CC
#define SIII_MA_CP_CMD_GET_RING_DELAY_CNF           0x48CD

#define SIII_MA_CP_CMD_CONFIGURE_SEQ_CNT_REQ        0x48CE
#define SIII_MA_CP_CMD_CONFIGURE_SEQ_CNT_CNF        0x48CF

#define SIII_MA_CP_CMD_GET_MASTER_FSM_STATUS_REQ    0x48D0
#define SIII_MA_CP_CMD_GET_MASTER_FSM_STATUS_CNF    0x48D1

#define SIII_MA_CP_CMD_GET_SLAVE_FSM_STATUS_REQ     0x48D2
#define SIII_MA_CP_CMD_GET_SLAVE_FSM_STATUS_CNF     0x48D3

#define SIII_MA_CP_CMD_GET_INITCMD_FSM_STATUS_REQ   0x48D4
#define SIII_MA_CP_CMD_GET_INITCMD_FSM_STATUS_CNF   0x48D5

//#define SIII_MA_CP_CMD_SET_TOPOLOGY_CONTROL_REQ     0x48D8
//#define SIII_MA_CP_CMD_SET_TOPOLOGY_CONTROL_CNF     0x48D9

#define SIII_MA_CP_CMD_GET_DEVICE_STATUS_REQ        0x48DA
#define SIII_MA_CP_CMD_GET_DEVICE_STATUS_CNF        0x48DB

#define SIII_MA_CP_CMD_GET_PORT_STATUS_REQ          0x48DC
#define SIII_MA_CP_CMD_GET_PORT_STATUS_CNF          0x48DD

#define SIII_MA_CP_CMD_GET_TOPOLOGY_FSM_STATUS_REQ  0x48DE
#define SIII_MA_CP_CMD_GET_TOPOLOGY_FSM_STATUS_CNF  0x48DF

#define SIII_MA_CP_CMD_GET_MST_TX_DIFF_REQ          0x48AE
#define SIII_MA_CP_CMD_GET_MST_TX_DIFF_CNF          0x48AF

/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_RING_DELAY_REQ/SIII_MA_CP_CMD_GET_RING_DELAY_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_RING_DELAY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_RING_DELAY_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_RING_DELAY_CNF_DATA_Ttag
{
  TLR_UINT32                                      ulRingDelay;                    /* if not valid this value is 0xFFFFFFFF */
  TLR_UINT32                                      ulDelayPrimaryPortLastCycle;    /* if not valid this value is 0xFFFFFFFF */
  TLR_UINT32                                      ulDelaySecondaryPortLastCycle;  /* if not valid this value is 0xFFFFFFFF */
  TLR_UINT32                                      ulRingDelayP;                   /* if not valid this value is 0xFFFFFFFF */
  TLR_UINT32                                      ulRingDelayS;                   /* if not valid this value is 0xFFFFFFFF */
} __TLR_PACKED_POST SIII_MA_CP_GET_RING_DELAY_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_RING_DELAY_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_RING_DELAY_CNF_DATA_T            tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_RING_DELAY_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_RING_DELAY_PCK_Ttag
{
  TLR_PACKET_HEADER_T             tHead;
  SIII_MA_CP_GET_RING_DELAY_REQ_T tReq;
  SIII_MA_CP_GET_RING_DELAY_CNF_T tCnf;
} SIII_MA_CP_GET_RING_DELAY_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_IFG_INFORMATION_REQ/SIII_MA_CP_CMD_GET_IFG_INFORMATION_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_IFG_INFORMATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_IFG_INFORMATION_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_IFG_INFORMATION_CNF_DATA_Ttag
{
  TLR_UINT32                                ulXc0_S3_IfgSizeNs;
  TLR_UINT32                                ulXc1_S3_IfgSizeNs;
  TLR_UINT32                                ulXc0_Nrt_IfgSizeNs;
  TLR_UINT32                                ulXc1_Nrt_IfgSizeNs;
  TLR_UINT32                                ulXc0_S3_IfgSizeInternal;
  TLR_UINT32                                ulXc1_S3_IfgSizeInternal;
  TLR_UINT32                                ulXc0_Nrt_IfgSizeInternal;
  TLR_UINT32                                ulXc1_Nrt_IfgSizeInternal;
  TLR_UINT32                                ulIfgSize_CP1_2;
  TLR_UINT32                                ulIfgSize_CP3_4;
} __TLR_PACKED_POST SIII_MA_CP_GET_IFG_INFORMATION_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_IFG_INFORMATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_GET_IFG_INFORMATION_CNF_DATA_T tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_IFG_INFORMATION_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_IFG_INFORMATION_PCK_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;
  SIII_MA_CP_GET_IFG_INFORMATION_REQ_T  tReq;
  SIII_MA_CP_GET_IFG_INFORMATION_CNF_T  tCnf;
} SIII_MA_CP_GET_IFG_INFORMATION_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_XC_COUNTERS_REQ/SIII_MA_CP_CMD_GET_XC_COUNTERS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_XC_COUNTERS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_XC_COUNTERS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_XC_COUNTERS_CNF_DATA_Ttag
{
  unsigned long aulFramesTransmittedOk[2];
  unsigned long aulSingleCollisionFrames[2];
  unsigned long aulMultipleCollisionFrames[2];
  unsigned long aulLateCollisions[2];
  unsigned long aulLinkDownDuringTransmission[2];
  unsigned long aulUtxUnderflowDuringTransmission[2];
  unsigned long aulTxDroppedDueNrtWindowTooSmall[2];
  unsigned long aulTxFatalErrors[2];
  unsigned long aulFramesReceivedOk[2];
  unsigned long aulFrameCheckSequenceErrors[2];
  unsigned long aulAlignmentErrors[2];
  unsigned long aulFrameTooLongErrors[2];
  unsigned long aulRuntFramesReceived[2];
  unsigned long aulCollisionFragmentsReceived[2];
  unsigned long aulFramesDroppedDueLowResource[2];
  unsigned long aulFramesDroppedDueUrxOverflow[2];
  unsigned long aulRxFatalErrors[2];
  unsigned long aulMdtNotUpdatedErrors[2];
  unsigned long aulAtNotUpdatedErrors[2];
} __TLR_PACKED_POST SIII_MA_CP_GET_XC_COUNTERS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_XC_COUNTERS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;
  SIII_MA_CP_GET_XC_COUNTERS_CNF_DATA_T     tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_XC_COUNTERS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_XC_COUNTERS_PCK_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  SIII_MA_CP_GET_XC_COUNTERS_REQ_T  tReq;
  SIII_MA_CP_GET_XC_COUNTERS_CNF_T  tCnf;
} SIII_MA_CP_GET_XC_COUNTERS_PCK_T;

/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_DEVICE_STATUS_REQ/SIII_MA_CP_CMD_GET_DEVICE_STATUS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DEVICE_STATUS_REQ_DATA_Ttag
{
  TLR_UINT16                                      usSlaveAddress;
} __TLR_PACKED_POST SIII_MA_CP_GET_DEVICE_STATUS_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DEVICE_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_DEVICE_STATUS_REQ_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_DEVICE_STATUS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DEVICE_STATUS_CNF_DATA_Ttag
{
  TLR_UINT16                                      usSlaveAddress;
  TLR_UINT16                                      usDebugInterfaceVersion;
  TLR_UINT16                                      usDeviceStatus;
  TLR_UINT16                                      usDeviceControl;
} __TLR_PACKED_POST SIII_MA_CP_GET_DEVICE_STATUS_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_DEVICE_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_DEVICE_STATUS_CNF_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_DEVICE_STATUS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_DEVICE_STATUS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_DEVICE_STATUS_REQ_T              tReq;
  SIII_MA_CP_GET_DEVICE_STATUS_CNF_T              tCnf;
} SIII_MA_CP_GET_DEVICE_STATUS_PCK_T;


/* Device Status word */
enum SIII_MA_CP_GET_DEVICE_STATUS_FIELDS_Etag
{
  MSK_SIII_MA_CP_GET_DEVICE_STATUS_PARAMETERIZATION_LEVELS          = 0x0010,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_PROC_COMMAND_CHANGE_BIT          = 0x0020,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_C2D_WARNING_BIT                  = 0x0040,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_C1D_ERROR_BIT                    = 0x0080,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_SLAVE_VALID                      = 0x0100,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_ERROR_OCCURED                    = 0x0200,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_INACTIVE_PORT_STATE              = 0x0C00,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_INACTIVE_PORT_STATE_NO_LINK      = 0x0000,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_INACTIVE_PORT_STATE_HAS_LINK     = 0x0400,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_INACTIVE_PORT_STATE_P_FRAMES     = 0x0800,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_INACTIVE_PORT_STATE_S_FRAMES     = 0x0C00,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_STATUS                  = 0x3000,
  SRT_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_STATUS                  = 12,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_STATUS_FAST_FORWARD     = 0x0000,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_STATUS_LOOP_ON_P1       = 0x1000,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_STATUS_LOOP_ON_P0       = 0x2000,
  VAL_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_STATUS_NRT_MODE         = 0x3000,

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_TOPOLOGY_HS                      = 0x4000, /* linked to MSK_SIIIM_DEVICE_CONTROL_TOPOLOGY_CHANGE_REQUEST_TOGGLE */

  MSK_SIII_MA_CP_GET_DEVICE_STATUS_COMMUNICATION_WARNING            = 0x8000
};

/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_PORT_STATUS_REQ/SIII_MA_CP_CMD_GET_PORT_STATUS_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_PORT_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_PORT_STATUS_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_PORT_STATUS_CNF_DATA_Ttag
{
  TLR_UINT16                                      usDebugInterfaceVersion;
  TLR_UINT8                                       bPrimaryPortStatus;
  TLR_UINT8                                       bSecondaryPortStatus;
  TLR_UINT8                                       bNrtForwardEnabled;
  TLR_UINT8                                       bNrtSendEnabled;
  TLR_UINT8                                       bPrimaryLinkStatus;
  TLR_UINT8                                       bSecondaryLinkStatus;
} __TLR_PACKED_POST SIII_MA_CP_GET_PORT_STATUS_CNF_DATA_T;

#define SIII_MA_CP_GET_PORT_STATUS_REV0_LEN 4
#define SIII_MA_CP_GET_PORT_STATUS_REV1_LEN 6
#define SIII_MA_CP_GET_PORT_STATUS_REV2_LEN 8

enum SIII_MA_CP_GET_PORT_STATUS_Etag
{
  SIII_MA_CP_GET_PORT_STATUS_NO_FRAMES      = 0,
  SIII_MA_CP_GET_PORT_STATUS_P_FRAMES       = 1,
  SIII_MA_CP_GET_PORT_STATUS_S_FRAMES       = 2
};

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_PORT_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_PORT_STATUS_CNF_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_PORT_STATUS_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_PORT_STATUS_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_PORT_STATUS_REQ_T                tReq;
  SIII_MA_CP_GET_PORT_STATUS_CNF_T                tCnf;
} SIII_MA_CP_GET_PORT_STATUS_PCK_T;

/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_CONFIGURE_SEQ_CNT_REQ/SIII_MA_CP_CMD_CONFIGURE_SEQ_CNT_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SEQ_CNT_REQ_DATA_Ttag
{
  TLR_UINT16 usSeqCntPrimary;
  TLR_UINT16 usSeqCntSecondary;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SEQ_CNT_REQ_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SEQ_CNT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_CONFIGURE_SEQ_CNT_REQ_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SEQ_CNT_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_CONFIGURE_SEQ_CNT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_CONFIGURE_SEQ_CNT_CNF_T;


/* packet union */
typedef union SIII_MA_CP_CONFIGURE_SEQ_CNT_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_CONFIGURE_SEQ_CNT_REQ_T              tReq;
  SIII_MA_CP_CONFIGURE_SEQ_CNT_CNF_T              tCnf;
} SIII_MA_CP_CONFIGURE_SEQ_CNT_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_TOPOLOGY_INFO_REQ/SIII_MA_CP_CMD_GET_TOPOLOGY_INFO_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_TOPOLOGY_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_TOPOLOGY_INFO_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_TOPOLOGY_INFO_CNF_DATA_Ttag
{
  TLR_UINT16                                      usNumSlavesPrimaryLine;
  TLR_UINT16                                      usNumSlavesSecondaryLine; /* 0xFFFF => ring */
  TLR_UINT16                                      usNumSlavesNotInTopology;
  TLR_UINT16                                      ausSlaveAddresses[512]; /* 1st primary slaves / 2nd secondary slaves / 3rd not in topology slaves */
} __TLR_PACKED_POST SIII_MA_CP_GET_TOPOLOGY_INFO_CNF_DATA_T;

#define SIII_MA_CP_GET_TOPOLOGY_INFO_MIN_SIZE     (3 * sizeof(TLR_UINT16))

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_TOPOLOGY_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_TOPOLOGY_INFO_CNF_DATA_T         tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_TOPOLOGY_INFO_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_TOPOLOGY_INFO_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_TOPOLOGY_INFO_REQ_T              tReq;
  SIII_MA_CP_GET_TOPOLOGY_INFO_CNF_T              tCnf;
} SIII_MA_CP_GET_TOPOLOGY_INFO_PCK_T;


/******************************************************************************
 * Packet:  SIII_MA_CP_CMD_GET_MST_TX_DIFF_REQ/SIII_MA_CP_CMD_GET_MST_TX_DIFF_CNF
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MST_TX_DIFF_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} __TLR_PACKED_POST SIII_MA_CP_GET_MST_TX_DIFF_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MST_TX_DIFF_CNF_DATA_Ttag
{
  TLR_INT32                                       lMstTxDifferenceNs;
  TLR_INT32                                       lSysTimeAddUpCorrection;        /* if not valid this value is 0 */
} __TLR_PACKED_POST SIII_MA_CP_GET_MST_TX_DIFF_CNF_DATA_T;

typedef __TLR_PACKED_PRE struct SIII_MA_CP_GET_MST_TX_DIFF_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_MST_TX_DIFF_CNF_DATA_T           tData;
} __TLR_PACKED_POST SIII_MA_CP_GET_MST_TX_DIFF_CNF_T;


/* packet union */
typedef union SIII_MA_CP_GET_MST_TX_DIFF_PCK_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_MA_CP_GET_MST_TX_DIFF_REQ_T                tReq;
  SIII_MA_CP_GET_MST_TX_DIFF_CNF_T                tCnf;
} SIII_MA_CP_GET_MST_TX_DIFF_PCK_T;


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(SIII_MA_CP_PUBLIC)
#endif

#endif /* S3M_CP_PUBLIC_H_INCLUDED */
